from PyTQt.tqt import TQFrame, TQStringList, TQVBoxLayout, TQ_SIGNAL, TQLabel, TQSizePolicy, TQt
from PyTQt.tqttable import TQTable
from tdeui import KTextEdit, KDatePicker, KDateWidget


labelText = 'KDatePicker'
iconName = 'date'
helpText = """A date selection widget.

Provides a widget for calendar date input.

Different from the previous versions, it now emits two types of
signals, either dateSelected() or dateEntered() (see documentation for
both signals).

A line edit has been added in the newer versions to allow the user to
select a date directly by entering numbers like 19990101 or 990101.
"""

class MainFrame(TQFrame):
    def __init__(self, parent=None):
        TQFrame.__init__(self, parent)
        self.help = KTextEdit(helpText, '', self)
        self.dateDisplay = KDateWidget(self)

        self.dateDisplay.setSizePolicy(TQSizePolicy(TQSizePolicy.Maximum,
                                                   TQSizePolicy.Maximum))
                                                   
        self.datePicker = KDatePicker(self)

        layout = TQVBoxLayout(self)
        layout.addWidget(self.help, 1)
        layout.addWidget(self.datePicker, 0, TQt.AlignHCenter)
        layout.addStretch(1)

        self.other = TQLabel('Selected Date:', self)
        layout.addWidget(self.other, 0)
        layout.addWidget(self.dateDisplay, 2)

        self.connect(self.datePicker, TQ_SIGNAL('dateChanged(TQDate)'),
                     self.dateDisplay.setDate)

