/*
 * qfloatinput.cpp
 *
 * Copyright (C)  2004  David Faure <faure@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#include "tqfloatinput.h"

#include <math.h>

TQFloatInput::TQFloatInput( int min, int max, float step, int digits,
                            TQWidget *parent, const char *name )
    : TQSpinBox( (int) (min*pow(digits,10)),
                (int) (max*pow(digits,10)),
                (int) (step*pow(digits,10)), parent, name ),
      m_digits( digits )
{
    setValue( (int) (min*pow(digits,10)) );
    delete validator();
    TQDoubleValidator* validator =
        new TQDoubleValidator( min,  max, m_digits, this );
    setValidator( validator );
}

TQString TQFloatInput::mapValueToText( int value )
{
    TQString format = TQString("%.%1f").arg( m_digits );
    return TQString().sprintf(format.latin1(),
                             (value/(float)pow(m_digits,10)) );
}

int TQFloatInput::mapTextToValue( bool* ok )
{
    return int(cleanText().toFloat(ok)*pow(m_digits,10));
}


