/*
    Kopete Oscar Protocol
    connector.h - the Oscar socket connector

    Copyright (c) 2004 Matt Rogers <matt.rogers@kdemail.net>
    Based on code Copyright (c) 2004 SuSE Linux AG <http://www.suse.com>
    Based on Iris, Copyright (C) 2003  Justin Karneges <justin@affinix.com>

    Kopete (c) 2002-2004 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef LIBKYAHOO_CONNECTOR_H
#define LIBKYAHOO_CONNECTOR_H


#include <tqobject.h>
#include "tqhostaddress.h"

class ByteStream;

class Connector : public TQObject
{
	TQ_OBJECT
  
public:
	Connector(TQObject *parent=0);
	virtual ~Connector();

	virtual void connectToServer(const TQString &server)=0;
	virtual ByteStream *stream() const=0;
	virtual void done()=0;

	bool havePeerAddress() const;
	TQHostAddress peerAddress() const;
	TQ_UINT16 peerPort() const;

signals:
	void connected();
	void error();

protected:
	void setPeerAddressNone();
	void setPeerAddress(const TQHostAddress &addr, TQ_UINT16 port);

private:
	bool haveaddr;
	TQHostAddress addr;
	TQ_UINT16 port;
};

#endif
