/*
 *  Copyright (c) 1998 Denis Perchine <dyp@perchine.com>
 *  Copyright (c) 2004 Szombathelyi György <gyurco@freemail.hu>
 *  Former maintainer: Adriaan de Groot <groot@kde.org>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#include <tqtooltip.h>
#include <tqtimer.h>

#include <tdetoolbar.h>
#include <kiconloader.h>
#include <tdeaction.h>
#include <tdelocale.h>
#include <kstdaction.h>

#include <kdebug.h>
#include <tdeaction.h>
#include <kstatusbar.h>
#include <kedittoolbar.h>

#include "kglobal_.h"
#include "editDefaults.h"
#include "mainWidget.h"
#include "selectconn.h"
#include "mainView.h"

mainWidget::mainWidget(const char *name) : TDEMainWindow(0,name)
{
  md = new mainView(this);

  setupActions();
  md->setShowSys( mShowSys->isChecked() );
  init();
  md->slotTabChanged();

  statusBar()->insertItem(i18n("Reading configuration"), 0);

  setCentralWidget(md);

  setupGUI();
	
  statusBar()->changeItem(i18n("Ready"), 0);
}

mainWidget::~mainWidget()
{
  delete md;
}

bool mainWidget::queryClose()
{
  return md->queryClose();
}

void mainWidget::setupActions()
{
  KStdAction::quit(this, TQ_SLOT(close()), actionCollection());
  KStdAction::keyBindings(guiFactory(), TQ_SLOT(configureShortcuts()), actionCollection());

  KStdAction::preferences(this, TQ_SLOT(properties()), actionCollection());

#define BarIconC(x)	BarIcon(TQString::fromLatin1(x))

  (void) new TDEAction(i18n("&Add..."), TQIconSet(BarIconC("add_user")), 0, md,
    TQ_SLOT(useradd()), actionCollection(), "add_user");

  (void) new TDEAction(i18n("&Edit..."), TQIconSet(BarIconC("edit_user")), 0, md,
    TQ_SLOT(useredit()), actionCollection(), "edit_user");

  (void) new TDEAction(i18n("&Delete..."), TQIconSet(BarIconC("delete_user")), 0, md,
    TQ_SLOT(userdel()), actionCollection(), "delete_user");

  (void) new TDEAction(i18n("&Set Password..."),
    0, md, TQ_SLOT(setpwd()), actionCollection(), "set_password_user");

  (void) new TDEAction(i18n("&Add..."), TQIconSet(BarIconC("add_group")), 0, md,
    TQ_SLOT(grpadd()), actionCollection(), "add_group");

  (void) new TDEAction(i18n("&Edit..."), TQIconSet(BarIconC("edit_group")), 0, md,
    TQ_SLOT(grpedit()), actionCollection(), "edit_group");

  (void) new TDEAction(i18n("&Delete"), TQIconSet(BarIconC("delete_group")), 0, md,
    TQ_SLOT(grpdel()), actionCollection(), "delete_group");

  (void) new TDEAction(i18n("&Reload"), TQIconSet(BarIconC("reload")), 0, this,
    TQ_SLOT(reload()), actionCollection(), "reload");

#undef BarIconC
	
  (void) new TDEAction(i18n("&Select Connection..."),
    0, this,
    TQ_SLOT(selectconn()), actionCollection(), "select_conn");

  mShowSys = new TDEToggleAction(i18n("Show System Users/Groups"),
    0, 0, this,
    TQ_SLOT(showSys()), actionCollection(), "show_sys");
  mShowSys->setCheckedState(i18n("Hide System Users/Groups"));
  mShowSys->setChecked( kug->kcfg()->showsys() );
}

void mainWidget::showSys()
{
  kug->kcfg()->setShowsys( mShowSys->isChecked() );
  md->setShowSys( mShowSys->isChecked() );
  md->reloadUsers();
  md->reloadGroups();
}

void mainWidget::properties()
{
  editDefaults *eddlg = new editDefaults( kug->kcfg(), this );
  connect(eddlg, TQ_SIGNAL(settingsChanged()), this, TQ_SLOT(slotApplySettings()));

  eddlg->show();
}

void mainWidget::reload()
{
  init();
}

void mainWidget::init()
{
  bool rw;

  md->clearUsers();
  md->clearGroups();
  kug->init();
  rw = ! ( kug->getUsers().getCaps() & KU::KUsers::Cap_ReadOnly );
  kdDebug() << "Users rw()" << rw << endl;
  actionCollection()->action("add_user")->setEnabled( rw );
  actionCollection()->action("edit_user")->setEnabled( rw );
  actionCollection()->action("delete_user")->setEnabled( rw );
  actionCollection()->action("set_password_user")->setEnabled( rw );
  if ( rw ) {
    connect( md, TQ_SIGNAL(userSelected(bool)),
      actionCollection()->action("edit_user"), TQ_SLOT(setEnabled(bool)) );
    connect( md, TQ_SIGNAL(userSelected(bool)),
      actionCollection()->action("delete_user"), TQ_SLOT(setEnabled(bool)) );
    connect( md, TQ_SIGNAL(userSelected(bool)),
      actionCollection()->action("set_password_user"), TQ_SLOT(setEnabled(bool)) );
  } else {
    disconnect( md, TQ_SIGNAL(userSelected(bool)), 0, 0 );
  }

  rw = ! ( kug->getGroups().getCaps() & KU::KGroups::Cap_ReadOnly );
  kdDebug() << "Groups rw()" << rw << endl;
  actionCollection()->action("add_group")->setEnabled( rw );
  actionCollection()->action("edit_group")->setEnabled( rw );
  actionCollection()->action("delete_group")->setEnabled( rw );
  if ( rw ) {
    connect( md, TQ_SIGNAL(groupSelected(bool)),
      actionCollection()->action("edit_group"), TQ_SLOT(setEnabled(bool)) );
    connect( md, TQ_SIGNAL(groupSelected(bool)),
      actionCollection()->action("delete_group"), TQ_SLOT(setEnabled(bool)) );
  } else {
    disconnect( md, TQ_SIGNAL(groupSelected(bool)), 0, 0 );
  }
  md->reloadUsers();
  md->reloadGroups();
  TQTimer::singleShot( 0, md, TQ_SLOT(slotTabChanged()) );
}

void mainWidget::slotApplySettings()
{
  kdDebug() << "settings changed!" << endl;
  init();
}

void mainWidget::slotApplyConnection()
{
  kdDebug() << "slotApplyConnection()" << endl;
  TQString conn = sc->connSelected();
  kug->kcfg()->setConnection( conn );
  kug->initCfg( conn );
  slotApplySettings();
}

void mainWidget::selectconn()
{
  sc = new SelectConn( kug->kcfg()->connection(), this, "selectconn" );
  connect( sc, TQ_SIGNAL(applyClicked()), TQ_SLOT(slotApplyConnection()) );
  connect( sc, TQ_SIGNAL(okClicked()), TQ_SLOT(slotApplyConnection()) );
  sc->show();
}

#include "mainWidget.moc"
