/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** TQt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

/*
 *  SQ_ThumbnailCacheMaster manipulates thumbnail cache
 *  in memory and on disk. It can show current cache size,
 *  delete cache on disk, clear cache etc.
 */

void SQ_ThumbnailCacheMaster::init()
{
    pushCache->setIconSet(SQ_IconLoader::instance()->loadIcon("kcalc", TDEIcon::Desktop, TDEIcon::SizeSmall));
    pushCacheMemory->setIconSet(SQ_IconLoader::instance()->loadIcon("kcalc", TDEIcon::Desktop, TDEIcon::SizeSmall));
    pushShowCache->setIconSet(SQ_IconLoader::instance()->loadIcon("memory", TDEIcon::Desktop, TDEIcon::SizeSmall));

    slotCalcCacheMemory();
}

void SQ_ThumbnailCacheMaster::slotCalcCache()
{
    SQ_DirThumbs tmp;

    KURL url = tmp.root();

    int size = KDirSize::dirSize(url);

    TQString s = TDEIO::convertSize(size);

    textThumbSize->setText(s);
}

void SQ_ThumbnailCacheMaster::slotClearCache()
{
    TQApplication::setOverrideCursor(TQCursor(TQt::WaitCursor));

    SQ_DirThumbs tmp;

    KURL url = tmp.root();

    TDEIO::DeleteJob *job = TDEIO::del(url);
    connect(job, TQ_SIGNAL(result(TDEIO::Job*)), this, TQ_SLOT(slotClearFinished(TDEIO::Job*)));
}

void SQ_ThumbnailCacheMaster::slotClearFinished( TDEIO::Job * )
{
    TQApplication::restoreOverrideCursor();
    slotCalcCache();
}

void SQ_ThumbnailCacheMaster::slotClearMemoryCache()
{
    TQApplication::setOverrideCursor(TQCursor(TQt::WaitCursor));

    SQ_PixmapCache::instance()->clear();
    slotCalcCacheMemory();

    TQApplication::restoreOverrideCursor();
}

void SQ_ThumbnailCacheMaster::slotCalcCacheMemory()
{
	textCacheMemSize->setText(TQString::fromLatin1("%1/%2")
				  .arg(TDEIO::convertSize(SQ_PixmapCache::instance()->totalSize()))
				  .arg(TDEIO::convertSize(SQ_PixmapCache::instance()->cacheLimit())));
}

void SQ_ThumbnailCacheMaster::slotShowDiskCache()
{
    SQ_ViewCache m_view(this);
    m_view.exec();
}

void SQ_ThumbnailCacheMaster::slotSyncCache()
{
    TQApplication::setOverrideCursor(TQCursor(TQt::WaitCursor));

    SQ_PixmapCache::instance()->sync();

    slotCalcCacheMemory();
    slotCalcCache();

    TQApplication::restoreOverrideCursor();
}
