/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2005-07-15
 * Description : themed icon view 
 * 
 * Copyright (C) 2005 by Renchi Raju <renchi at pooh.tam.uiuc.edu>
 * Copyright (C) 2006-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// Local includes.

#include "themeengine.h"
#include "themedicongroupitem.h"
#include "themediconitem.h"
#include "themediconview.h"
#include "themediconview.moc"

namespace Digikam
{

class ThemedIconViewPriv
{
public:
    
    int   thumbSize;
    
    TQRect itemRect;
    TQRect itemDateRect;
    TQRect itemPixmapRect;
    TQRect itemNameRect;
    TQRect itemCommentsRect;
    TQRect itemResolutionRect;
    TQRect itemSizeRect;
    TQRect itemTagRect;
    TQRect bannerRect;

    TQPixmap itemRegPixmap;
    TQPixmap itemSelPixmap;
    TQPixmap bannerPixmap;

    TQFont fnReg;
    TQFont fnCom;
    TQFont fnXtra;
};

ThemedIconView::ThemedIconView(TQWidget* parent)
              : IconView(parent)
{
    d = new ThemedIconViewPriv;
    d->thumbSize = 128;


    ThemedIconGroupItem* groupItem = new ThemedIconGroupItem(this);
    for (int i=0; i<10; i++)
    {
        ThemedIconItem* item = new ThemedIconItem(groupItem);
        if (i > 0 && i < 3)
            item->setSelected(true, false);
    }
    
    updateBannerRectPixmap();
    updateItemRectsPixmap();

    connect(ThemeEngine::instance(), TQ_SIGNAL(signalThemeChanged()),
            this, TQ_SLOT(slotThemeChanged()));
}

ThemedIconView::~ThemedIconView()
{    
    delete d;
}

TQRect ThemedIconView::itemRect() const
{
    return d->itemRect;
}

TQRect ThemedIconView::itemDateRect() const
{
    return d->itemDateRect;
}

TQRect ThemedIconView::itemPixmapRect() const
{
    return d->itemPixmapRect;
}

TQRect ThemedIconView::itemNameRect() const
{
    return d->itemNameRect;
}

TQRect ThemedIconView::itemCommentsRect() const
{
    return d->itemCommentsRect;
}

TQRect ThemedIconView::itemResolutionRect() const
{
    return d->itemResolutionRect;
}

TQRect ThemedIconView::itemTagRect() const
{
    return d->itemTagRect;
}

TQRect ThemedIconView::itemSizeRect() const
{
    return d->itemSizeRect;
}

TQRect ThemedIconView::bannerRect() const
{
    return d->bannerRect;
}

TQPixmap* ThemedIconView::itemBaseRegPixmap() const
{
    return &d->itemRegPixmap;
}

TQPixmap* ThemedIconView::itemBaseSelPixmap() const
{
    return &d->itemSelPixmap;
}

TQPixmap ThemedIconView::bannerPixmap() const
{
    return d->bannerPixmap;
}

TQFont ThemedIconView::itemFontReg() const
{
    return d->fnReg;
}

TQFont ThemedIconView::itemFontCom() const
{
    return d->fnCom;
}

TQFont ThemedIconView::itemFontXtra() const
{
    return d->fnXtra;
}

void ThemedIconView::slotThemeChanged()
{
    updateBannerRectPixmap();
    updateItemRectsPixmap();

    viewport()->update();
}

void ThemedIconView::resizeEvent(TQResizeEvent* e)
{
    IconView::resizeEvent(e);

    if (d->bannerRect.width() != frameRect().width())
        updateBannerRectPixmap();
}

void ThemedIconView::updateBannerRectPixmap()
{
    d->bannerRect = TQRect(0, 0, 0, 0);

    // Title --------------------------------------------------------
    TQFont fn(font());
    int fnSize = fn.pointSize();
    bool usePointSize;
    if (fnSize > 0)
    {
        fn.setPointSize(fnSize+2);
        usePointSize = true;
    }
    else
    {
        fnSize = fn.pixelSize();
        fn.setPixelSize(fnSize+2);
        usePointSize = false;
    }

    fn.setBold(true);
    TQFontMetrics fm(fn);
    TQRect tr = fm.boundingRect(0, 0, frameRect().width(),
                               0xFFFFFFFF, TQt::AlignLeft | TQt::AlignVCenter,
                               "XXX");
    d->bannerRect.setHeight(tr.height());

    if (usePointSize)
        fn.setPointSize(font().pointSize());
    else
        fn.setPixelSize(font().pixelSize());

    fn.setBold(false);
    fm = TQFontMetrics(fn);

    tr = fm.boundingRect(0, 0, frameRect().width(),
                         0xFFFFFFFF, TQt::AlignLeft | TQt::AlignVCenter,
                         "XXX");

    d->bannerRect.setHeight(d->bannerRect.height() + tr.height() + 10);
    d->bannerRect.setWidth(frameRect().width());

    d->bannerPixmap = ThemeEngine::instance()->bannerPixmap(d->bannerRect.width(),
                                                            d->bannerRect.height());
}

void ThemedIconView::updateItemRectsPixmap()
{
    d->itemRect = TQRect(0,0,0,0);
    d->itemDateRect = TQRect(0,0,0,0);
    d->itemPixmapRect = TQRect(0,0,0,0);
    d->itemNameRect = TQRect(0,0,0,0);
    d->itemCommentsRect = TQRect(0,0,0,0);
    d->itemResolutionRect = TQRect(0,0,0,0);
    d->itemSizeRect = TQRect(0,0,0,0);
    d->itemTagRect = TQRect(0,0,0,0);

    d->fnReg  = font();
    d->fnCom  = font();
    d->fnXtra = font();
    d->fnCom.setItalic(true);

    int fnSz = d->fnReg.pointSize();
    if (fnSz > 0)
    {
        d->fnCom.setPointSize(fnSz-1);
        d->fnXtra.setPointSize(fnSz-2);
    }
    else
    {
        fnSz = d->fnReg.pixelSize();
        d->fnCom.setPixelSize(fnSz-1);
        d->fnXtra.setPixelSize(fnSz-2);
    }

    int margin  = 5;
    int w = d->thumbSize + 2*margin;

    TQFontMetrics fm(d->fnReg);
    TQRect oneRowRegRect = fm.boundingRect(0, 0, w, 0xFFFFFFFF,
                                          TQt::AlignTop | TQt::AlignHCenter,
                                          "XXXXXXXXX");
    fm = TQFontMetrics(d->fnCom);
    TQRect oneRowComRect = fm.boundingRect(0, 0, w, 0xFFFFFFFF,
                                          TQt::AlignTop | TQt::AlignHCenter,
                                          "XXXXXXXXX");
    fm = TQFontMetrics(d->fnXtra);
    TQRect oneRowXtraRect = fm.boundingRect(0, 0, w, 0xFFFFFFFF,
                                           TQt::AlignTop | TQt::AlignHCenter,
                                           "XXXXXXXXX");

    int y = margin;

    d->itemPixmapRect = TQRect(margin, y, w, d->thumbSize+margin);
    y = d->itemPixmapRect.bottom();

    {
        d->itemNameRect = TQRect(margin, y, w, oneRowRegRect.height());
        y = d->itemNameRect.bottom();
    }

    {
        d->itemCommentsRect = TQRect(margin, y, w, oneRowComRect.height());
        y = d->itemCommentsRect.bottom();
    }

    {
        d->itemDateRect = TQRect(margin, y, w, oneRowXtraRect.height());
        y = d->itemDateRect.bottom();
    }

    {
        d->itemTagRect = TQRect(margin, y, w, oneRowComRect.height());
        y = d->itemTagRect.bottom();
    }

    d->itemRect = TQRect(0, 0, w+2*margin, y+margin);

    d->itemRegPixmap = ThemeEngine::instance()->thumbRegPixmap(d->itemRect.width(),
                                                               d->itemRect.height());

    d->itemSelPixmap = ThemeEngine::instance()->thumbSelPixmap(d->itemRect.width(),
                                                               d->itemRect.height());
}

}  // NameSpace Digikam
