/*
Gwenview - A simple image viewer for TDE
Copyright 2000-2004 Aur�lien G�teau
 
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 
*/
#ifndef DOCUMENTANIMATEDIMPL_H
#define DOCUMENTANIMATEDIMPL_H

// TQt
#include <tqimage.h>
#include <tqvaluevector.h>

// Local
#include "documentloadedimpl.h"
#include "imageutils/imageutils.h"
#include "imageframe.h"

class TQFile;
class TQCString;

namespace Gwenview {
class Document;

class DocumentAnimatedLoadedImplPrivate;

class DocumentAnimatedLoadedImpl : public DocumentLoadedImpl {
TQ_OBJECT
  
public:
	DocumentAnimatedLoadedImpl(Document* document, const ImageFrames& frames);
	~DocumentAnimatedLoadedImpl();
	void init();
	
	void transform(ImageUtils::Orientation);
	virtual bool canBeSaved() const { return false; }

protected:
	TQString localSave(TQFile*, const TQCString& format) const;
	
private slots:
	void nextFrame();
private:
	DocumentAnimatedLoadedImplPrivate* d;
};

} // namespace
#endif /* DOCUMENTANIMATEDIMPL_H */

