# Copyright 1999-2020 Gentoo Authors
# Copyright 2020-2025 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_MODULE_NAME="tdebase"
TRINITY_MODULE_TYPE="core"
TRINITY_HANDBOOK="never"
TSM_EXTRACT_ALSO="kcheckpass/ FindXscreensaver.cmake"
inherit flag-o-matic trinity-meta-2

DESCRIPTION="The part of TDE UI that handles icons, desktop, screensaver etc"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi
IUSE="hwlib pam sak +svg xscreensaver"

COMMON_DEPEND="
	~dev-libs/dbus-1-tqt-${PV}
	~trinity-base/kcontrol-${PV}[svg?]
	~trinity-base/libkonq-${PV}
	x11-libs/libXrender
	x11-libs/libXcursor
	xscreensaver? ( x11-libs/libXScrnSaver x11-misc/xscreensaver )"
	# Requires the desktop background settings module,
	# so until we separate the kcontrol modules into separate ebuilds :-),
	# there's a dep here
DEPEND="${COMMON_DEPEND}
	xscreensaver? ( x11-base/xorg-proto )"
RDEPEND="${COMMON_DEPEND}
	~trinity-base/kcheckpass-${PV}
	~trinity-base/kdialog-${PV}
	~trinity-base/konqueror-${PV}
	pam? ( trinity-base/tdebase-pam )
	sak? ( trinity-base/tdm[sak] )
"

src_configure() {
	# cmake's BUILD_TSAK is used for both building the tsak/tdmtsak binaries
	# and for optional support in kdesktop, so we pass it via preprocessor args
	# rather than via proper configuration
	# TODO: fix after https://mirror.git.trinitydesktop.org/gitea/TDE/tdebase/pulls/653
	use sak && append-cppflags -DBUILD_TSAK

	local mycmakeargs=(
		-DWITH_XCURSOR=ON
		-DWITH_XRENDER=ON
		-DWITH_LIBART="$(usex svg)"
		-DWITH_PAM="$(usex pam)"
		-DWITH_XSCREENSAVER="$(usex xscreensaver)"
		-DTDESCREENSAVER_PAM_SERVICE=tde
		-DWITH_TDEHWLIB="$(usex hwlib)"
	)
	trinity-meta-2_src_configure
}

pkg_postinst() {
	if use sak; then
		ewarn "Note that in order to use Secure Attention Key feature in"
		ewarn "kdesktop you have to use trinity-base/tdm as your display"
		ewarn "manager and also enable SAK support in it as well."
	fi
}
