# Copyright 2024-2025 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

# We don't actually use autotools build, but it prevents cmake from beeing inherited
TRINITY_BUILD_ADMIN=yes
TRINITY_MODULE_TYPE="libraries"

PYTHON_COMPAT=( python3_{11..14} )
DISTUTILS_SINGLE_IMPL=1
DISTUTILS_EXT=1
# Despite the package provides setup.py, it seems to be incompatible with DISTUTILS_USE_PEP517=setuptools
DISTUTILS_USE_PEP517=standalone

inherit trinity-base-2 distutils-r1

DESCRIPTION="Python extensions for TDE"
HOMEPAGE="https://trinitydesktop.org/"
LICENSE="GPL-2"
SLOT="0"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi
REQUIRED_USE="${PYTHON_REQUIRED_USE}"

DEPEND="${PYTHON_DEPS}
	~dev-python/pytde-${PV}[${PYTHON_SINGLE_USEDEP}]
"
RDEPEND="${DEPEND}"

PATCHES=(
	"${FILESDIR}/${P}-Fix-FTBFS-caused-by-mkpath-returning-nothing.patch"
	"${FILESDIR}/${PN}-14.1.4-Avoid-byte-compiling-in-case-it-is-disabled.patch"
)

src_compile() {
	esetup.py build build_libpythonize --clib="-lgcc_s"
}

src_install() {
	esetup.py install --root "$D" --skip-build
	python_optimize

	# purge undesireables
	rm -r "${D}/$(python_get_sitedir)"/*.egg-info || die
}
