/***************************************************************************
                          confwizard.cpp  -  description
                             -------------------
    begin                : Son Jun 16 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "confwizard.h"
#include "sqltables.h"
#include "printersettings.h"
#include "dsmainwindow.h"

// TQt includes
#include <tqbuttongroup.h>
#include <tqcheckbox.h>
#include <tqcursor.h>
#include <tqlayout.h>
#include <tqsqldatabase.h>
#include <tqradiobutton.h>
#include <tqprinter.h>
#include <tqtextbrowser.h>

// KDE includes
#include <tdeapplication.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <kpushbutton.h>
#include <kurllabel.h>
#include <kstandarddirs.h>


const char* description = I18N_NOOP(
        "KBarcode is a barcode and label printing application for TDE. It can "
        "be used to print every thing from simple business cards up to complex "
        "labels with several barcodes (e.g. article descriptions). KBarcode "
        "comes with an easy to use WYSIWYG label designer, a setup wizard, "
        "batch import of labels (directly from the delivery note), thousands "
        "of predefined labels, database management tools and translations "
        "in many languages. Even printing more than 10.000 labels in one go is "
        "no problem for KBarcode. Additionally it is a simply xbarcode "
        "replacement for the creation of barcodes. All major types of barcodes "
        "like EAN, UPC, CODE39 and ISBN are supported." );

ConfWizard::ConfWizard( TQWidget* parent,  const char* name, bool modal )
    : KWizard( parent, name, modal )
{
    setCaption( i18n( "Configure KBarcode" ) );

    setupPage1();
    setupPage0();
    setupPage2();
    setupPage3();

    setNextEnabled( page_2, false );
    helpButton()->hide();
    
    connect( buttonCreate, TQ_SIGNAL( clicked() ), this, TQ_SLOT( create() ) );
    connect( buttonExample, TQ_SIGNAL( clicked() ), this, TQ_SLOT( example() ) );
    connect( checkDatabase, TQ_SIGNAL( clicked() ), this, TQ_SLOT( useDatabase() ) );
}

ConfWizard::~ConfWizard()
{ }

void ConfWizard::accept()
{
    sqlwidget->save( checkDatabase->isChecked() );

    KWizard::accept();
}

void ConfWizard::setupPage1()
{
    page = new TQWidget( this, "page" );
    pageLayout = new TQVBoxLayout( page, 11, 6, "pageLayout");

    Layout8 = new TQHBoxLayout( 0, 0, 6, "Layout8");

    Layout7 = new TQVBoxLayout( 0, 0, 6, "Layout7");

    logo = new TQLabel( page, "logo" );
    logo->setPixmap( locate("data", "kbarcode/logo.png") );
    TQSpacerItem* spacer = new TQSpacerItem( 0, 0, TQSizePolicy::Minimum, TQSizePolicy::Expanding );
    pageLayout->addWidget( logo );
    Layout7->addItem( spacer );
    Layout8->addLayout( Layout7 );

    TextLabel2_2 = new TQLabel( page, "TextLabel2_2" );
    TextLabel2_2->setText( i18n( "<qt><h1>Welcome to KBarcode</h1><br><br>") +
        i18n( description ) + "</qt>" );
    Layout8->addWidget( TextLabel2_2 );

    pageLayout->addLayout( Layout8 );

    KURLLabel1 = new KURLLabel( page, "KURLLabel1" );
    KURLLabel1->setText( "http://www.trinitydesktop.org" );
    KURLLabel1->setURL("http://www.trinitydesktop.org");
    pageLayout->addWidget( KURLLabel1 );
    addPage( page, i18n( "Welcome" ) );
}

void ConfWizard::setupPage0()
{
    TQWidget* page_0 = new TQWidget( this, "page_0" );
    TQVBoxLayout* pageLayout = new TQVBoxLayout( page_0, 11, 6, "pageLayout");

    TQTextBrowser* b = new TQTextBrowser( page_0, "b" );
    b->setText( DSMainWindow::systemCheck() );

    pageLayout->addWidget( b );
    
    addPage( page_0, i18n("System Check") );
}

void ConfWizard::setupPage2()
{
    page_2 = new TQWidget( this, "page_2" );
    pageLayout_2 = new TQVBoxLayout( page_2, 11, 6, "pageLayout_2");

    checkDatabase = new TQCheckBox( page_2 );
    checkDatabase->setText( i18n("&Use database with KBarcode") );
    checkDatabase->setChecked( true );

    sqlwidget = new SqlWidget( true, page_2, "sqlwidget" );
    connect( sqlwidget, TQ_SIGNAL( databaseWorking( bool ) ), this, TQ_SLOT( testSettings( bool ) ) );
        
    TQSpacerItem* spacer_5 = new TQSpacerItem( 0, 0, TQSizePolicy::Minimum, TQSizePolicy::Expanding );
    pageLayout_2->addWidget( checkDatabase );
    pageLayout_2->addWidget( sqlwidget );
    pageLayout_2->addItem( spacer_5 );

    addPage( page_2, i18n( "Database" ) );
}

void ConfWizard::setupPage3()
{
    page_3 = new TQWidget( this, "page_3" );
    pageLayout_3 = new TQVBoxLayout( page_3, 11, 6, "pageLayout_3");

    TextLabel1_2 = new TQLabel( page_3, "TextLabel1_2" );
    TextLabel1_2->setText( i18n( "KBarcode can create the required SQL tables for you.<br>KBarcode will add also some Label Definitions to the tables.<br>After that you can fill the tables with some example data." ) );
    TextLabel1_2->setAlignment( int( TQLabel::WordBreak | TQLabel::AlignVCenter ) );
    pageLayout_3->addWidget( TextLabel1_2 );

    Layout5_2 = new TQVBoxLayout( 0, 0, 6, "Layout5_2");

    buttonCreate = new KPushButton( page_3, "buttonCreate" );
    buttonCreate->setText( i18n( "&Create Tables" ) );
    Layout5_2->addWidget( buttonCreate );

    buttonExample = new KPushButton( page_3, "buttonExample" );
    buttonExample->setEnabled( false );
    buttonExample->setText( i18n( "&Add Example Data" ) );
    Layout5_2->addWidget( buttonExample );
    TQSpacerItem* spacer_6 = new TQSpacerItem( 0, 0, TQSizePolicy::Minimum, TQSizePolicy::Expanding );
    Layout5_2->addItem( spacer_6 );
    pageLayout_3->addLayout( Layout5_2 );
    addPage( page_3, i18n( "Create Tables" ) );
}

void ConfWizard::testSettings( bool b )
{
    setNextEnabled( page_2, b );
}

void ConfWizard::create()
{
    TDEApplication::setOverrideCursor( TQt::WaitCursor );
    if(!SqlTables::getInstance()->newTables( sqlwidget->username(), sqlwidget->password(), sqlwidget->hostname(), sqlwidget->database(), sqlwidget->driver() ) )
    {
        TDEApplication::restoreOverrideCursor();
        return;
    }
    else
        TDEApplication::restoreOverrideCursor();

    TQSqlDatabase* db = TQSqlDatabase::addDatabase( sqlwidget->driver() );
    db->setDatabaseName( sqlwidget->database() );
    db->setUserName( sqlwidget->username() );
    db->setPassword( sqlwidget->password() );
    db->setHostName( sqlwidget->hostname() );

    if( !db->open() )
        KMessageBox::error( this, i18n("<qt>Connection failed:<br>") + sqlwidget->database(),
              db->lastError().databaseText() + "</qt>" );

    if( db->open() ) {
        TDEApplication::setOverrideCursor( TQt::WaitCursor );
        SqlTables::getInstance()->importData(
            locate("appdata", "labeldefinitions.sql"), db );
        buttonExample->setEnabled( true );
        TDEApplication::restoreOverrideCursor();
    }

    db->close();
}

void ConfWizard::example()
{
    TQSqlDatabase* db = TQSqlDatabase::addDatabase( sqlwidget->driver() );
    db->setDatabaseName( sqlwidget->database() );
    db->setUserName( sqlwidget->username() );
    db->setPassword( sqlwidget->password() );
    db->setHostName( sqlwidget->hostname() );

    if( !db->open() )
        KMessageBox::error( this, i18n("<qt>Connection failed:<br>") + sqlwidget->database(),
              db->lastError().databaseText() + "</qt>" );


    SqlTables::getInstance()->importData(
        locate("appdata", "exampledata.sql"), db );
    KMessageBox::information( this, i18n("Example data has been imported.") );

    db->close();
}

void ConfWizard::showPage( TQWidget* page )
{
    TQWizard::showPage(page);

    if( page == page_2 && !sqlwidget->driverCount() ) {
        KMessageBox::information( this, i18n(
            "There are no TQt SQL drivers installed. "
            "KBarcode needs those drivers to access the different SQL databases. "
            "This drivers are part of the TQt Source distribution and should also be part of "
            "your distribution. Please install them first.") );
    }
    
    if ( page == page_3 )
        finishButton()->setEnabled( true );
}

void ConfWizard::useDatabase()
{
    setFinishEnabled( page_2, !checkDatabase->isChecked() );
    setNextEnabled( page_2, false );
    setFinishEnabled( page_3, checkDatabase->isChecked() );
    sqlwidget->setEnabled( checkDatabase->isChecked() );
}


#include "confwizard.moc"
