/****************************************************************************
**
** Copyright (C) 2011 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
** $QT_END_LICENSE$
**
****************************************************************************/

#include <tqcheckbox.h>
#include <tqcombobox.h>
#include <tqradiobutton.h>
#include <tqpushbutton.h>
#include <tqprogressbar.h>
#include <tqtextedit.h>
#include <tqtabbar.h>
#include <tqtoolbar.h>
#include <tqtoolbutton.h>
#include <tqmainwindow.h>
#include <tqlayout.h>
#include <tqaction.h>
#include <tqgroupbox.h>

#include "stylewindow.h"

StyleWindow::StyleWindow()
{
    TQGroupBox *styleBox = new TQGroupBox(10,TQt::Vertical,tr("A simple style button"),this);
//    styleBox->resize(200,200);

    TQPushButton *styledButton = new TQPushButton(tr("Big Red Button"),styleBox);
    TQRadioButton *styledRadioButton = new TQRadioButton(tr("Little Radio Button"),styleBox);
    TQCheckBox *styledCheckBox = new TQCheckBox(tr("Little Check Box"),styleBox);
    TQComboBox *styledComboBox = new TQComboBox(styleBox);
    TQTextEdit *styledTextEdit = new TQTextEdit(styleBox);
    TQProgressBar *styledProgressBar = new TQProgressBar(styleBox);
    TQTabBar *styledTabBar = new TQTabBar(styleBox);
    TQMainWindow *styledMainWindow = new TQMainWindow(this);

//    TQGridLayout *layout = new TQGridLayout(styleBox);
//    layout->addWidget(styledButton,0,0);
//    layout->addWidget(styledRadioButton,1,0);
//    layout->addWidget(styledCheckBox,2,0);
//    layout->addWidget(styledComboBox,3,0);
//    layout->addWidget(styledTextEdit,4,0);
//    layout->addWidget(styledProgressBar,5,0);
//    layout->addWidget(styledTabBar,6,0);

    styledComboBox->insertItem("Hello");
    styledComboBox->insertItem("There");
    styledComboBox->insertItem("Raja!");
    styledTextEdit->setText("TEST");
    styledProgressBar->setTotalSteps(100);
    styledProgressBar->setProgress(50);

    TQTab* tab1 = new TQTab("Tab 1");
    TQTab* tab2 = new TQTab("Tab 2");
    TQTab* tab3 = new TQTab("Tab Duplicate");
    TQTab* tab4 = new TQTab("Tab Duplicate");
    TQTab* tab5 = new TQTab("Tab Duplicate");
    TQTab* tab6 = new TQTab("Tab 3");
    TQTab* tab7 = new TQTab("Tab Duplicate");
    TQTab* tab8 = new TQTab("Tab Duplicate");

    styledTabBar->addTab(tab1);
    styledTabBar->addTab(tab2);
    styledTabBar->addTab(tab3);
    styledTabBar->addTab(tab4);
    styledTabBar->addTab(tab5);
    styledTabBar->addTab(tab6);
    styledTabBar->addTab(tab7);
    styledTabBar->addTab(tab8);

    TQToolBar *styledToolBar = new TQToolBar(styledMainWindow);
    TQAction* toolbutton1 = new TQAction(styledToolBar);
    toolbutton1->setText("Save");
    toolbutton1->addTo(styledToolBar);

    TQGridLayout *outerLayout = new TQGridLayout(this);
    outerLayout->addWidget(styleBox, 0, 0);

//    setWindowTitle(tr("Style Plugin Example"));
}
