/*
	systemconfig.h - A system configuration manager
	Copyright (C) 2005  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __SYSTEMCONFIG_H__
#define __SYSTEMCONFIG_H__

#include <kdialogbase.h>

class TDEListView;
class TDEListViewItem;

/** @short A system configuration manager. */
class SystemConfig: KDialogBase
{
	TQ_OBJECT
public:
	/**
	 * Returns @c true if the <b>shut down</b> and @b reboot functions are available.
	 */
	static bool canShutDown();

	/**
	 * Shows a modal dialog, and checks the system configuration.
	 * @param parent A parent widget
	 */
	static void check(TQWidget *parent);
private:
	enum Type { Info, OK, Warning };
	static int _canShutDown;
	int _problems;
	TDEListView *_messages;
	TDEListViewItem
		*_tdmNotDetected,
		*_shutdownAllowItem;
	SystemConfig(TQWidget *parent);
	TDEListViewItem *add(const Type type, const TQString &message);
	void checkFile(const TQString &file);
	void checkTDE();
	void checkTDM();
private slots:
	void slotExecuted(TQListViewItem *item);
};

#endif // __SYSTEMCONFIG_H__
