/***************************************************************************
 *
 * tdenetman-connection_setting_vpn_widget.cpp - A NetworkManager frontend for TDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef TDENETWORKMANAGER_CONNECTION_SETTING_VPN_WIDGET_H
#define TDENETWORKMANAGER_CONNECTION_SETTING_VPN_WIDGET_H


// tqt headers
#include <tqwidget.h>
#include <tqlineedit.h>

// tdenm headers
#include "connection_setting_vpn.h"
#include "tdenetman-connection_setting_widget_interface.h"
#include "tdenetman-connection_settings_dialog.h"

class VPNService;
class VPNConfigWidget;

namespace ConnectionSettings
{

class VPNWidgetImpl : public WidgetInterface
{
	TQ_OBJECT
  
	public:
		VPNWidgetImpl(TDENetworkConnection* conn, bool new_conn, TQWidget* parent = NULL, const char* name = NULL, WFlags fl = 0);
		void Activate();
		void Deactivate();
	public slots:
		void slotServiceComboActivated(int);

	private:
		void Init();
		VPNConfigWidget* getVPNConfigWidget(VPNService* service);

		bool _new_conn;
		TDEVPNConnection* _vpnsetting;
		ConnectionSettingVPNWidget* _mainWid;
		TQMap<int, VPNService*> _mapServiceCombo;
		TQMap<VPNService*, VPNConfigWidget*> _mapServiceWidget;

		ConnectionSettingsDialogImpl* _parentdialog;
};

}
#endif /* TDENETWORKMANAGER_CONNECTION_SETTING_VPN_WIDGET_H*/
