
/***************************************************************************
   begin                : Wed Mar 13 2002
   copyright            : (C) 2002 by Christian Hubinger
   email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfruleeditorstate.h"

// TQt includes
#include <tqstring.h>
#include <tqptrlist.h>
#include <tqcheckbox.h>

// kde includes
#include <kdebug.h>
#include <tdelocale.h>
#include <tdeapplication.h>
#include <tdemessagebox.h>

// ProjectIncludes
#include "../../core/xmlnames.h"
#include "../../core/iptruleoption.h"
#include "../../core/iptrule.h"
#include "../../core/iptchain.h"
#include "../../core/iptable.h"
#include "../../core/kmfdoc.h"
#include "../../core/kmfiptdoc.h"
#include "../../core/kmfnetwork.h"
#include "../../core/kmfundoengine.h"
namespace KMF {
KMFRuleEditorState::KMFRuleEditorState( TQWidget *parent, const char *name, WFlags fl /*,IPTRule* cr*/ ) : KMyFirewallRuleEditorState( parent, name, fl ) {}
KMFRuleEditorState::~KMFRuleEditorState() {}

void KMFRuleEditorState::loadRule( IPTRule *rule ) {
	kdDebug() << "void KMFRuleEditorState::loadRule( IPTRule *rule )" << endl;
	c_use_conntrack->setChecked( false );
	c_new->setChecked( false );
	c_related->setChecked( false );
	c_established->setChecked( false );
	c_invalid->setChecked( false );
	m_rule = rule;
	readRuleConfig();
}

void KMFRuleEditorState::slotOk() {
	KMFUndoEngine::instance()->startTransaction( 
		m_rule,
		i18n("Edit Rule: %1 State Option").arg( m_rule->name() ) 
	);
	bool s_new = c_new->isChecked();
	bool s_related = c_related->isChecked();
	bool s_established = c_established->isChecked();
	bool s_invalid = c_invalid->isChecked();
	TQPtrList<TQString>* options = new TQPtrList<TQString>;
	TQString* name = new TQString( "state_opt" );

	if ( c_use_conntrack->isChecked() ) {
		if ( !s_new && !s_related && !s_established && !s_invalid ) {
			KMessageBox::sorry( this, i18n( "You must at least choose one of the available states." ), i18n( "Configure Connection Tracking" ) );
			KMFUndoEngine::instance()->abortTransaction();
			return ;
		}
		TQString* opt = new TQString( "" );
		if ( s_new ) {
			opt->append( ",NEW" );
		}
		if ( s_related ) {
			opt->append( ",RELATED" );
		}
		if ( s_established ) {
			opt->append( ",ESTABLISHED" );
		}
		if ( s_invalid ) {
			opt->append( ",INVALID" );
		}
		if ( opt->startsWith( "," ) )
			* opt = opt->right( opt->length() - 1 );
		options->append( new TQString(XML::BoolOn_Value) );
		options->append( opt );
	}
	// emit sigAddRuleOpt( name, options );
	m_rule->addRuleOption( *name, *options );
	KMFUndoEngine::instance()->endTransaction();
	emit sigHideMe();
}

void KMFRuleEditorState::readRuleConfig() {
	IPTRuleOption *opt = 0;
	opt = m_rule->getOptionForName("state_opt");
	if (opt) {
		TQStringList vals = opt->getValues();
		TQString val = "";
		val = *vals.at(1);
			if ( val != XML::Undefined_Value ) {
				c_use_conntrack->setChecked( true );
				if ( val.contains( "NEW" ) )
					c_new->setChecked( true );
				if ( val.contains( "RELATED" ) )
					c_related->setChecked( true );
				if ( val.contains( "ESTABLISHED" ) )
					c_established->setChecked( true );
				if ( val.contains( "INVALID" ) )
					c_invalid->setChecked( true );
			}
	}
}
void KMFRuleEditorState::slotHelp() {
	kdDebug() << "void KMFRuleEditorState::slotHelp()" << endl;
	kapp->invokeHelp( "state" );
}
void KMFRuleEditorState::reject() {
	kdDebug() << "void KMFRuleEditorState::reject()" << endl;
	emit sigHideMe();
}

}

#include "kmfruleeditorstate.moc"
