/***************************************************************************
             mpagedisplay.cpp  -  Kugar page display widget
             -------------------
   begin     : Sun Aug 15 1999
   copyright : (C) 1999 by Mutiny Bay Software
   email     : info@mutinybaysoftware.com
***************************************************************************/

#include "mpagedisplay.h"

namespace Kugar
{

/** Constructor */
MPageDisplay::MPageDisplay( TQWidget *parent, const char *name ) : TQWidget( parent, name )
{
    buffer.resize( 1, 1 );
}

/** Destructor */
MPageDisplay::~MPageDisplay()
{}

/** Sets the report page image */
void MPageDisplay::setPage( TQPicture* image )
{
    buffer.fill( white );
    TQPainter p( &buffer );
    image->play( &p );
}

/** Display object's paint event */
void MPageDisplay::paintEvent( TQPaintEvent* event )
{
    bitBlt( this, 0, 0, &buffer );
}

/** Sets the page display dimensions */
void MPageDisplay::setPageDimensions( TQSize size )
{
    buffer.resize( size );
    resize( size );
}


// Return the preferred size of the display.

TQSize MPageDisplay::sizeHint() const
{
    return buffer.size();
}


// Return the size policy.

TQSizePolicy MPageDisplay::sizePolicy() const
{
    return TQSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed );
}

}

#include "mpagedisplay.moc"
