/* This file is part of the KDE project
   Copyright (C) 2004 Jaroslaw Staniek <js@iidea.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "kexisectionheader.h"
#include "kexiviewbase.h"
#include <kexiutils/utils.h>

#include <tqlabel.h>
#include <tqlayout.h>
#include <tqhbox.h>
#include <tqtooltip.h>

#include <kiconloader.h>
#include <kpushbutton.h>

class KexiSectionHeader::BoxLayout : public TQBoxLayout
{
	public:
		BoxLayout( KexiSectionHeader* parent, Direction d, int margin = 0, 
			int spacing = -1, const char * name = 0 );
		virtual void addItem( TQLayoutItem * item );
		TQGuardedPtr<KexiViewBase> view;
};

//==========================

//! @internal
class KexiSectionHeaderPrivate
{
	public:
		KexiSectionHeaderPrivate() 
		{
		}
	
		TQt::Orientation orientation;
		TQLabel *lbl;
		KexiSectionHeader::BoxLayout *lyr;
		TQHBox *lbl_b;
};

//==========================

KexiSectionHeader::KexiSectionHeader(const TQString &caption, TQt::Orientation o, TQWidget* parent )
	: TQWidget(parent, "KexiSectionHeader")
	, d( new KexiSectionHeaderPrivate() )
{
	d->orientation = o;
	d->lyr = new BoxLayout( this, d->orientation==TQt::Vertical ? TQBoxLayout::TopToBottom : TQBoxLayout::LeftToRight );
	d->lyr->setAutoAdd(true);
	d->lbl_b = new TQHBox(this);
	d->lbl = new TQLabel(TQString(" ")+caption, d->lbl_b);
	d->lbl->setSizePolicy(TQSizePolicy::Minimum, TQSizePolicy::Preferred);
	d->lbl->setFocusPolicy(TQWidget::StrongFocus);
	d->lbl->installEventFilter(this);
	installEventFilter(this);
	setCaption(caption);
}

KexiSectionHeader::~KexiSectionHeader()
{
	delete d;
}

void KexiSectionHeader::addButton(const TQString& icon, const TQString& toolTip,
	const TQObject * receiver, const char * member)
{
	KPushButton *btn = new KPushButton(d->lbl_b);
	btn->setFlat(true);
	btn->setFocusPolicy(TQWidget::NoFocus);
	btn->setSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Preferred);
	if (receiver && member) {
		connect(btn, TQ_SIGNAL(clicked()), receiver, member);
	}

	if (!icon.isEmpty()) {
		TQIconSet iset = SmallIconSet(icon);
		btn->setIconSet( iset );
		TQFontMetrics fm(d->lbl->font());
		btn->setMaximumHeight( TQMAX(fm.height(), 16) );
	}
	if (!toolTip.isEmpty()) {
		TQToolTip::add(btn, toolTip);
	}
}

bool KexiSectionHeader::eventFilter( TQObject *o, TQEvent *e )
{
	if (o == d->lbl && e->type()==TQEvent::MouseButtonRelease) {//|| e->type()==TQEvent::FocusOut) {// && o->inherits("TQWidget")) {
		if (d->lyr->view)
			d->lyr->view->setFocus();
//		if (KexiUtils::hasParent( this, o)) {
//			d->lbl->setPaletteBackgroundColor( e->type()==TQEvent::FocusIn ? red : blue);
//		}
	}
	return TQWidget::eventFilter(o,e);
}

void KexiSectionHeader::slotFocus(bool in)
{
	in = in || focusWidget()==this;
	d->lbl->setPaletteBackgroundColor( 
		in ? palette().active().color(TQColorGroup::Highlight) : palette().active().color(TQColorGroup::Background) );
	d->lbl->setPaletteForegroundColor( 
		in ? palette().active().color(TQColorGroup::HighlightedText) : palette().active().color(TQColorGroup::Foreground) );
}

TQSize KexiSectionHeader::sizeHint() const
{
	if (!d->lyr->view)
		return TQWidget::sizeHint();
	TQSize s = d->lyr->view->sizeHint();
	return TQSize(s.width(), d->lbl->sizeHint().height() + s.height());
}

/*void KexiSectionHeader::setFocus()
{
	if (d->lyr->view)
		d->lyr->view->setFocus();
	else
		TQWidget::setFocus();
}*/

//======================

KexiSectionHeader::BoxLayout::BoxLayout( KexiSectionHeader* parent, Direction d, int margin, int spacing, const char * name )
 : TQBoxLayout(parent, d, margin, spacing, name )
{
}

void KexiSectionHeader::BoxLayout::addItem( TQLayoutItem * item )
{
	TQBoxLayout::addItem( item );
	if (item->widget()) {
		item->widget()->installEventFilter( mainWidget() );
		if (item->widget()->inherits("KexiViewBase")) {
			view = static_cast<KexiViewBase*>(item->widget());
			KexiSectionHeader *sh = static_cast<KexiSectionHeader*>(mainWidget());
			connect(view,TQ_SIGNAL(focus(bool)),sh,TQ_SLOT(slotFocus(bool)));
			sh->d->lbl->setBuddy(item->widget());
		}
	}
}


#include "kexisectionheader.moc"

