/*
 * This file is part of the KDE project
 *
 * This file was copied from ksnapshot
 *
 * Copyright (C) 2001 Nikolas Zimmermann <wildfox@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <tdelocale.h>
#include <kiconloader.h>
#include <tdeinstance.h>
#include <tdemessagebox.h>
#include <kstandarddirs.h>
#include <tdetempfile.h>
#include <kdebug.h>
#include <KoView.h>
#include <KoDocument.h>
#include <kgenericfactory.h>
#include <tdelocale.h>

#include "ksnapshot.h"
#include <kimageio.h>
#include <kis_view.h>
#include <kis_image.h>
#include "screenshot.moc"


K_EXPORT_COMPONENT_FACTORY( chalkscreenshot, KGenericFactory<Screenshot>( "chalk" ) )

Screenshot::Screenshot(TQObject *parent, const char *name, const TQStringList &)
        : KParts::Plugin(parent, name)
{
    TDEGlobal::locale()->insertCatalogue("kscreenshot_plugin");
    setInstance(KGenericFactory<Screenshot>::instance());
    setXMLFile(locate("data","chalkplugins/screenshot-chalk.rc"), true);
    KImageIO::registerFormats();

    snapshot = new KSnapshot();
    TQ_CHECK_PTR(snapshot);
    connect( snapshot, TQ_SIGNAL( screenGrabbed() ), TQ_SLOT( slotScreenGrabbed() ) );

    (void) new TDEAction(i18n("&Screenshot..."), SmallIcon("tool_screenshot"), 0, this, TQ_SLOT(slotScreenshot()), actionCollection(), "screenshot");

}

Screenshot::~Screenshot()
{
    delete snapshot;
}

void Screenshot::slotScreenshot()
{
    snapshot->show();
}

void Screenshot::slotScreenGrabbed()
{
    KTempFile temp(locateLocal("tmp", "screenshot"), ".png");
    snapshot->save(temp.name());

    KisView *view = dynamic_cast<KisView *>(parent());
    if(view)
        view->importImage(temp.name());
}
