/***************************************************************************
                             knewuserwizard.cpp
                             -------------------
    begin                : Sat Feb 18 2006
    copyright            : (C) 2006 Thomas Baumgart
    email                : Thomas Baumgart <ipwizard@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <locale.h>

// ----------------------------------------------------------------------------
// TQt Includes

#include <tqpixmap.h>
#include <tqbitmap.h>
#include <tqcheckbox.h>
#include <tqpushbutton.h>
#include <tqdir.h>
#include <tqlabel.h>

// ----------------------------------------------------------------------------
// TDE Includes

#include <tdelocale.h>
#include <tdelistview.h>
#include <kstandarddirs.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <kuser.h>
#include <kurlrequester.h>
#include <tdeio/netaccess.h>
#include <kurl.h>
#include <tdeabc/addressee.h>
#include <tdeabc/stdaddressbook.h>
#include <tdemessagebox.h>
#include <kactivelabel.h>

// ----------------------------------------------------------------------------
// Project Includes

#include "knewuserwizard.h"
#include "knewuserwizard_p.h"
#include <kmymoney/mymoneysecurity.h>
#include <kmymoney/mymoneyfile.h>
#include <kmymoney/kguiutils.h>
#include <kmymoney/kmymoneyaccounttree.h>
#include <kmymoney/mymoneypayee.h>
#include <kmymoney/mymoneymoney.h>
#include <kmymoney/mymoneyinstitution.h>
#include <kmymoney/mymoneyaccount.h>
#include <kmymoney/kmymoneydateinput.h>
#include <kmymoney/kmymoneyedit.h>
#include <kmymoney/kaccounttemplateselector.h>

#include "../../kmymoney2.h"
#include "../../kmymoneyglobalsettings.h"

using namespace NewUserWizard;

static int stepCount;

NewUserWizard::Wizard::Wizard(TQWidget *parent, const char *name, bool modal, WFlags flags) :
  KMyMoneyWizard(parent, name, modal, flags),
  m_introPage(0)
{
  bool isFirstTime = KMyMoneyGlobalSettings::firstTimeRun();

  stepCount = 1;

  setTitle(i18n("KMyMoney New File Setup"));
  if(isFirstTime)
    addStep(i18n("Introduction"));
  addStep(i18n("Personal Data"));
  addStep(i18n("Select Currency"));
  addStep(i18n("Select Accounts"));
  addStep(i18n("Set preferences"));
  addStep(i18n("Finish"));

  if(isFirstTime)
    m_introPage = new IntroPage(this);
  m_generalPage = new GeneralPage(this);
  m_currencyPage = new CurrencyPage(this);
  m_accountPage = new AccountPage(this);
  m_categoriesPage = new CategoriesPage(this);
  m_preferencePage = new PreferencePage(this);
  m_filePage = new FilePage(this);

  m_accountPage->m_haveCheckingAccountButton->setChecked(true);
  if(isFirstTime)
    setFirstPage(m_introPage);
  else
    setFirstPage(m_generalPage);

  setHelpContext("firsttime-3");
}

MyMoneyPayee NewUserWizard::Wizard::user(void) const
{
  return m_generalPage->user();
}

TQString NewUserWizard::Wizard::url(void) const
{
  return m_filePage->m_dataFileEdit->url();
}

MyMoneyInstitution NewUserWizard::Wizard::institution(void) const
{
  MyMoneyInstitution inst;
  if(m_accountPage->m_haveCheckingAccountButton->isChecked()) {
    if(m_accountPage->m_institutionNameEdit->text().length()) {
      inst.setName(m_accountPage->m_institutionNameEdit->text());
      if(m_accountPage->m_institutionNumberEdit->text().length())
        inst.setSortcode(m_accountPage->m_institutionNumberEdit->text());
    }
  }
  return inst;
}

MyMoneyAccount NewUserWizard::Wizard::account(void) const
{
  MyMoneyAccount acc;
  if(m_accountPage->m_haveCheckingAccountButton->isChecked()) {
    acc.setName(m_accountPage->m_accountNameEdit->text());
    if(m_accountPage->m_accountNumberEdit->text().length())
      acc.setNumber(m_accountPage->m_accountNumberEdit->text());
    acc.setOpeningDate(m_accountPage->m_openingDateEdit->date());
    acc.setCurrencyId(m_baseCurrency.id());
    acc.setAccountType(MyMoneyAccount::Checkings);
  }
  return acc;
}

MyMoneyMoney NewUserWizard::Wizard::openingBalance(void) const
{
  return m_accountPage->m_openingBalanceEdit->value();
}

MyMoneySecurity NewUserWizard::Wizard::baseCurrency(void) const
{
  return m_baseCurrency;
}

TQValueList<MyMoneyTemplate> NewUserWizard::Wizard::templates(void) const
{
  return m_categoriesPage->selectedTemplates();
}

IntroPage::IntroPage(Wizard* wizard, const char* name) :
  KIntroPageDecl(wizard),
  WizardPage<Wizard>(stepCount++, this, wizard, name)
{
}

KMyMoneyWizardPage* IntroPage::nextPage(void) const
{
  return m_wizard->m_generalPage;
}

GeneralPage::GeneralPage(Wizard* wizard, const char* name) :
  UserInfo(wizard),
  WizardPage<Wizard>(stepCount++, this, wizard, name)
{
  m_userNameEdit->setFocus();
  TDEABC::StdAddressBook *ab = TDEABC::StdAddressBook::self(true);
  connect(ab, TQ_SIGNAL(addressBookChanged(AddressBook*)), this, TQ_SLOT(slotAddressBookLoaded()));
  connect(m_loadAddressButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotLoadFromKABC()));
  m_loadAddressButton->setEnabled(false);
}

void GeneralPage::slotAddressBookLoaded(void)
{
  TDEABC::StdAddressBook *ab = TDEABC::StdAddressBook::self();
  if (!ab)
    return;

  m_loadAddressButton->setEnabled(!ab->whoAmI().isEmpty());
}

void GeneralPage::slotLoadFromKABC(void)
{
  TDEABC::StdAddressBook *ab = TDEABC::StdAddressBook::self();
  if (!ab)
    return;

  TDEABC::Addressee addr = ab->whoAmI();
  if ( addr.isEmpty() ) {
    KMessageBox::sorry(this, i18n("Unable to load data, because no contact has been associated with the owner of the standard addressbook."), i18n("Addressbook import"));
    return;
  }

  m_userNameEdit->setText( addr.formattedName() );
  m_emailEdit->setText( addr.preferredEmail() );

  TDEABC::PhoneNumber phone = addr.phoneNumber( TDEABC::PhoneNumber::Home );
  m_telephoneEdit->setText( phone.number() );

  TDEABC::Address a = addr.address( TDEABC::Address::Home );
  TQString sep;
  if(!a.country().isEmpty() && !a.region().isEmpty())
    sep = " / ";
  m_countyEdit->setText(TQString("%1%2%3").arg(a.country(), sep, a.region()));
  m_postcodeEdit->setText( a.postalCode() );
  m_townEdit->setText( a.locality() );
  m_streetEdit->setText( a.street() );
}

KMyMoneyWizardPage* GeneralPage::nextPage(void) const
{
  return m_wizard->m_currencyPage;
}

CurrencyPage::CurrencyPage(Wizard* wizard, const char* name) :
  Currency(wizard),
  WizardPage<Wizard>(stepCount++, this, wizard, name)
{
  TQListViewItem *first = 0;
  TQValueList<MyMoneySecurity> list = MyMoneyFile::instance()->currencyList();
  TQValueList<MyMoneySecurity>::const_iterator it;

  TQString localCurrency(localeconv()->int_curr_symbol);
  localCurrency.truncate(3);

  TQString baseCurrency = MyMoneyFile::instance()->baseCurrency().id();

  // construct a transparent 16x16 pixmap
  TQPixmap empty(16, 16);
  empty.setMask(TQBitmap(16, 16, true));

  m_currencyList->clear();
  for(it = list.begin(); it != list.end(); ++it) {
    TQListViewItem* p = insertCurrency(*it);
    if((*it).id() == baseCurrency) {
      first = p;
      p->setPixmap(0, TQPixmap( locate("icon","hicolor/16x16/apps/kmymoney2.png")));
    } else {
      p->setPixmap(0, empty);
    }
    if(!first && (*it).id() == localCurrency)
      first = p;
  }

  if(first == 0)
    first = m_currencyList->firstChild();
  if(first != 0) {
    m_currencyList->setCurrentItem(first);
    m_currencyList->setSelected(first, true);
    m_currencyList->ensureItemVisible(first);
  }
}

void CurrencyPage::enterPage(void)
{
  m_currencyList->setFocus();
}


KMyMoneyWizardPage* CurrencyPage::nextPage(void) const
{
  m_wizard->m_baseCurrency = MyMoneyFile::instance()->security(selectedCurrency());
  m_wizard->m_accountPage->m_accountCurrencyLabel->setText(m_wizard->m_baseCurrency.tradingSymbol());
  return m_wizard->m_accountPage;
}

AccountPage::AccountPage(Wizard* wizard, const char* name) :
  KAccountPageDecl(wizard, name),
  WizardPage<Wizard>(stepCount, this, wizard, name)       // don't inc. the step count here
{
  m_mandatoryGroup->add(m_accountNameEdit);
  connect(m_mandatoryGroup, TQ_SIGNAL(stateChanged()), object(), TQ_SIGNAL(completeStateChanged()));
  connect(m_haveCheckingAccountButton, TQ_SIGNAL(toggled(bool)), object(), TQ_SIGNAL(completeStateChanged()));
  m_accountNameEdit->setFocus();
  m_openingDateEdit->setDate(TQDate(TQDate::currentDate().year(),1,1));
}

KMyMoneyWizardPage* AccountPage::nextPage(void) const
{
  return m_wizard->m_categoriesPage;
}

bool AccountPage::isComplete(void) const
{
  return !m_haveCheckingAccountButton->isChecked() || m_mandatoryGroup->isEnabled();
}

CategoriesPage::CategoriesPage(Wizard* wizard, const char* name) :
  Accounts(wizard),
  WizardPage<Wizard>(stepCount++, this, wizard, name)
{
}

KMyMoneyWizardPage* CategoriesPage::nextPage(void) const
{
  return m_wizard->m_preferencePage;
}

TQValueList<MyMoneyTemplate> CategoriesPage::selectedTemplates(void) const
{
  return m_templateSelector->selectedTemplates();
}

PreferencePage::PreferencePage(Wizard* wizard, const char* name) :
  KPreferencePageDecl(wizard),
  WizardPage<Wizard>(stepCount++, this, wizard, name)
{
  connect(m_openConfigButton, TQ_SIGNAL(clicked()), kmymoney2, TQ_SLOT(slotSettings()));
}

KMyMoneyWizardPage* PreferencePage::nextPage(void) const
{
  return m_wizard->m_filePage;
}

FilePage::FilePage(Wizard* wizard, const char* name) :
  KFilePageDecl(wizard),
  WizardPage<Wizard>(stepCount++, this, wizard, name)
{
  m_mandatoryGroup->add(m_dataFileEdit->lineEdit());
  connect(m_mandatoryGroup, TQ_SIGNAL(stateChanged()), object(), TQ_SIGNAL(completeStateChanged()));

  KUser user;
  m_dataFileEdit->setShowLocalProtocol(false);
  m_dataFileEdit->setURL(TQString("%1/%2.kmy").arg(TQDir::homeDirPath(), user.loginName()));

  // allow selection of non-existing files
  m_dataFileEdit->setMode(KFile::File);
}

bool FilePage::isComplete(void) const
{
  bool rc = m_mandatoryGroup->isEnabled();
  m_existingFileLabel->hide();
  m_finishLabel->show();
  if(rc) {
    // if a filename is present, check that
    // a) the file does not exist
    // b) the directory does exist
    rc = !TDEIO::NetAccess::exists(m_dataFileEdit->url(), false, m_wizard);
    if(rc) {
      TQRegExp exp("(.*)/(.*)");
      rc = false;
      if(exp.search(m_dataFileEdit->url()) != -1) {
        if(exp.cap(2).length() > 0) {
          rc = TDEIO::NetAccess::exists(exp.cap(1), true, m_wizard);
        }
      }
    }
    m_existingFileLabel->setHidden(rc);
    m_finishLabel->setShown(rc);
  }
  return rc;
}

#include "knewuserwizard.moc"
#include "knewuserwizard_p.moc"
