/***************************************************************************
                           mathenvdialog.h
----------------------------------------------------------------------------
    date                 : Dec 06 2005
    version              : 0.21
    copyright            : (C) 2005 by Holger Danielsson
    email                : holger.danielsson@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MATHENVDIALOG_H
#define MATHENVDIALOG_H

#include "kileinfo.h"
#include "kilewizard.h"
#include "latexcmd.h"

#include <klineedit.h>

#include <tqlabel.h>
#include <tqcheckbox.h>
#include <tqcombobox.h>
#include <tqspinbox.h>
#include <tqbuttongroup.h>
#include <tqmap.h>
#include <tqvaluelist.h>
 
namespace KileDialog
{

class MathEnvironmentDialog : public Wizard  
{
	TQ_OBJECT
  

public:
	MathEnvironmentDialog(TQWidget *parent, TDEConfig *config, KileInfo *ki, KileDocument::LatexCommands *commands);
	~MathEnvironmentDialog() {}
	
public slots:
	void slotOk();

private slots:
	void slotEnvironmentChanged(int index);  
	void slotSpinboxValueChanged(int index);  

private:
	KileInfo *m_ki;
	KileDocument::LatexCommands *m_latexCommands;
	
	TQComboBox *m_coEnvironment, *m_coTabulator, *m_coDisplaymath;
	TQCheckBox *m_cbStarred, *m_cbBullets;
	TQSpinBox *m_spRows, *m_spCols;
	TQLabel *m_lbRows, *m_lbCols, *m_lbSpace ;
	TQLabel *m_lbTabulator, *m_lbDisplaymath, *m_lbStarred;
	TQLabel *m_lbEnvironment, *m_lbBullets;
	KLineEdit *m_edSpace;
	
	TQString m_envname;
	bool m_starred;
	bool m_groups;
	bool m_columns;
	bool m_fixedcolumns;
	bool m_mathmode;
	TQString m_tabulator;
	TQString m_parameter;
		
	void initEnvironments();
	bool isParameterEnv();
	bool isGroupsParameterEnv();
};

}

#endif
