/***************************************************************************
    begin                : Fri Aug 15 2003
    copyright            : (C) 2003 by Jeroen Wijnhout
                           (C) 2007 by Holger Danielsson
    email                : Jeroen.Wijnhout@kdemail.net
                           holger.danielsson@versanet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KILELISTSELECTOR_H
#define KILELISTSELECTOR_H

#include <kdialogbase.h>
#include <tdelistview.h>

class TDEListView;
class TQStringList;

class KileListSelectorBase : public KDialogBase
{
public:
	KileListSelectorBase(const TQStringList &list, const TQString &caption, const TQString &select, TQWidget *parent=0, const char *name=0);
	~KileListSelectorBase() {}

	int currentItem();

protected:
	TDEListView *m_listview;
	void insertStringList(const TQStringList &list);
};

class KileListSelector : public KileListSelectorBase
{
public:
	KileListSelector(const TQStringList &list, const TQString &caption, const TQString &select, TQWidget *parent=0, const char *name=0);
	~KileListSelector() {}
};

class KileListSelectorMultiple : public KileListSelectorBase
{
public:
	KileListSelectorMultiple(const TQStringList & list, const TQString &caption, const TQString &select, TQWidget *parent=0, const char *name=0);
	~KileListSelectorMultiple() {}

	const TQStringList &selected();

private:
	TQStringList m_selectedfiles;
};


#endif
