/***************************************************************************
                          knutfrontpanel.cpp  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "knutfrontpanel.h"
#include "knutvardata.h"
#include "knutnet.h"

#include <tdelocale.h>
#include <tdeapplication.h>

#include <tqtooltip.h>
#include <tqstring.h>
#include <tqpaintdevice.h>
#include <tqlayout.h>
#include <tqlcdnumber.h>
#include <tqlabel.h>
#include <tqcolor.h>
#include <tqfont.h>
#include <tqpalette.h>
#include <tqgroupbox.h>

#include <math.h>

KNutFrontPanel::KNutFrontPanel( TQPalette* const paletteIn, TQWidget *parent, const unsigned int flags, TQFont* const panelFonts, const char *name) : TQFrame( parent, name ), m_panelFlags(flags) {

  m_myPalette = TQPalette(*paletteIn); // makes deep copy of palette
  m_upsOkColor = TQt::green;
  m_upsErrorColor = TQt::red;
  m_upsBackColor = TQt::white; //backgroundColor();
  m_helpColor = TQt::black;
  m_typeOfLCDColor=true;
  m_LCDNumber1 = 0;


  setFrameStyle( TQFrame::Box | TQFrame::Raised );
  setLineWidth( 2 );

  if (panelFonts == 0) {
    m_panelFont =kapp->font(); // sets font - system font
    m_panelBoldFont = kapp->font();
    }
  else {
    m_panelFont = *panelFonts; // sets font / our selected font
    m_panelBoldFont = *panelFonts; // change later
    }
  m_panelBoldFont.setBold (true);
  m_panelFont.setBold (false); // sets no bold

  m_mainLayout = new TQVBoxLayout(this);
  m_mainLayout->setMargin ( 10 );
  m_mainLayout->setSpacing ( 10 );

  // layer for bulbs

  m_bulbsGroupBox = new TQGroupBox(this);
  m_mainLayout->addWidget(m_bulbsGroupBox);
  m_bulbsGroupBox->setFrameStyle( TQFrame::Panel + TQFrame::Raised);
//  m_bulbsGroupBox->setFrameStyle( TQFrame::Panel + TQFrame::Sunken);
  m_bulbsGroupBox->setLineWidth(2);
  TQVBoxLayout* bulbsLayout = new TQVBoxLayout(m_bulbsGroupBox);
  bulbsLayout->setMargin( 5 );


  m_textLabel1 = new TQLabel( i18n("UPS On line"),m_bulbsGroupBox);
  m_frameOL = new KLed (m_upsBackColor,KLed::Off,KLed::Sunken,KLed::Circular,m_bulbsGroupBox);
  m_frameOL->setMaximumSize(30,30);
  m_frameOL->setMinimumSize(25,25);
  TQToolTip::add(m_textLabel1,m_textLabel1->text());

  TQHBoxLayout* OLLayout = new TQHBoxLayout(bulbsLayout);
  OLLayout->addWidget(m_textLabel1);
  OLLayout->addSpacing(10); 
  OLLayout->addWidget(m_frameOL);
  OLLayout->setMargin (3);
  OLLayout->setStretchFactor(m_textLabel1,20);
  OLLayout->setStretchFactor(m_frameOL,5);


  m_textLabel2 = new TQLabel( i18n("UPS On battery"), m_bulbsGroupBox);
  m_frameOB = new KLed (m_upsBackColor,KLed::Off,KLed::Sunken,KLed::Circular,m_bulbsGroupBox);
  m_frameOB->setMaximumSize(30,30);
  m_frameOB->setMinimumSize(25,25);
  TQToolTip::add(m_textLabel2,m_textLabel2->text());

  TQHBoxLayout* OBLayout = new TQHBoxLayout(bulbsLayout);
  OBLayout->addWidget(m_textLabel2);
  OBLayout->addSpacing(10); 
  OBLayout->addWidget(m_frameOB);
  OBLayout->setMargin (3);
  OBLayout->setStretchFactor(m_textLabel2,20);
  OBLayout->setStretchFactor(m_frameOB,5);


  m_textLabel3 = new TQLabel( i18n("UPS Overload"), m_bulbsGroupBox);
  m_frameOVER = new  KLed (m_upsBackColor,KLed::Off,KLed::Sunken,KLed::Circular,m_bulbsGroupBox);
  m_frameOVER->setMaximumSize(30,30);
  m_frameOVER->setMinimumSize(25,25);
  TQToolTip::add(m_textLabel3,m_textLabel3->text());

  m_OLayout = new TQHBoxLayout(bulbsLayout);
  m_OLayout->addWidget(m_textLabel3);
  m_OLayout->addSpacing(10); 
  m_OLayout->addWidget(m_frameOVER);
  m_OLayout->setMargin (3);
  m_OLayout->setStretchFactor(m_textLabel3,20);
  m_OLayout->setStretchFactor(m_frameOVER,5);

  m_textLabel4 = new TQLabel( i18n("UPS Battery low"), m_bulbsGroupBox);
  m_frameLB = new  KLed (m_upsBackColor,KLed::Off,KLed::Sunken,KLed::Circular,m_bulbsGroupBox);
  m_frameLB->setMaximumSize(30,30);
  m_frameLB->setMinimumSize(25,25);
  TQToolTip::add(m_textLabel4,m_textLabel4->text());

  m_LBLayout = new TQHBoxLayout(bulbsLayout);
  m_LBLayout->addWidget(m_textLabel4);
  m_LBLayout->addSpacing(10); 
  m_LBLayout->addWidget(m_frameLB);
  m_LBLayout->setMargin (3);
  m_LBLayout->setStretchFactor(m_textLabel4,20);
  m_LBLayout->setStretchFactor(m_frameLB,5);

  m_textLabel5 = new TQLabel( i18n("Replace battery"), m_bulbsGroupBox);
  m_frameRB = new  KLed (m_upsBackColor,KLed::Off,KLed::Sunken,KLed::Circular,m_bulbsGroupBox);
  m_frameRB->setMaximumSize(30,30);
  m_frameRB->setMinimumSize(25,25);
  TQToolTip::add(m_textLabel5,m_textLabel5->text());

  m_RBLayout = new TQHBoxLayout(bulbsLayout);
  m_RBLayout->addWidget(m_textLabel5);
  m_RBLayout->addSpacing(10); 
  m_RBLayout->addWidget(m_frameRB);
  m_RBLayout->setMargin (3);
  m_RBLayout->setStretchFactor(m_textLabel5,20);
  m_RBLayout->setStretchFactor(m_frameRB,5);

  m_textLabel6 = new TQLabel( i18n("UPS calibration"), m_bulbsGroupBox);
  m_frameCAL = new  KLed (m_upsBackColor,KLed::Off,KLed::Sunken,KLed::Circular,m_bulbsGroupBox);
  m_frameCAL->setMaximumSize(30,30);
  m_frameCAL->setMinimumSize(25,25);
  TQToolTip::add(m_textLabel6,m_textLabel6->text());

  m_CALLayout = new TQHBoxLayout(bulbsLayout);
  m_CALLayout->addWidget(m_textLabel6);
  m_CALLayout->addSpacing(10); 
  m_CALLayout->addWidget(m_frameCAL);
  m_CALLayout->setMargin (3);
  m_CALLayout->setStretchFactor(m_textLabel6,20);
  m_CALLayout->setStretchFactor(m_frameCAL,5);


  m_messGroupBox = new TQGroupBox(this);
  m_mainLayout->addWidget(m_messGroupBox);
  m_messGroupBox->setFrameStyle( TQFrame::Panel + TQFrame::Raised);
//  m_messGroupBox->setFrameStyle( TQFrame::Panel + TQFrame::Sunken);
  m_messGroupBox->setLineWidth(2);
  TQVBoxLayout* messLayout = new TQVBoxLayout(m_messGroupBox);
  messLayout->setMargin( 3 );


  m_textLabel7 = new TQLabel( "", m_messGroupBox);
  TQToolTip::add(m_textLabel7,m_textLabel7->text());
  m_manufacModelLayout = new TQHBoxLayout(messLayout);
  m_manufacModelLayout->addWidget(m_textLabel7);
  m_manufacModelLayout->setMargin ( 3 );

  m_textLabelManufac = new TQLabel( i18n("Manufac. : "), m_messGroupBox);
  m_textLabel8 = new TQLabel( "", m_messGroupBox);
  TQToolTip::add(m_textLabelManufac,m_textLabelManufac->text());

  m_manufacLayout = new TQHBoxLayout(messLayout);
  m_manufacLayout->addWidget(m_textLabelManufac);
  m_manufacLayout->addWidget(m_textLabel8);
  m_manufacLayout->addStretch(20);
  m_manufacLayout->setMargin ( 3 );

  m_textLabelName = new TQLabel( i18n("Name")+" : ", m_messGroupBox);
  m_textLabel9 = new TQLabel( "", m_messGroupBox);
  TQToolTip::add(m_textLabelName,m_textLabelName->text());

  m_nameLayout = new TQHBoxLayout(messLayout);
  m_nameLayout->addWidget(m_textLabelName);
  m_nameLayout->addWidget(m_textLabel9);
  m_nameLayout->addStretch(20);
  m_nameLayout->setMargin ( 3 );

  m_textLabelSerial = new TQLabel( i18n("Serial : "), m_messGroupBox);
  m_textLabel10 = new TQLabel( "", m_messGroupBox);
  TQToolTip::add(m_textLabelSerial,m_textLabelSerial->text());

  m_serialLayout = new TQHBoxLayout(messLayout);
  m_serialLayout->addWidget(m_textLabelSerial);
  m_serialLayout->addWidget(m_textLabel10);
  m_serialLayout->addStretch(20);
  m_serialLayout->setMargin ( 3 );

  m_textLabelFirm = new TQLabel( i18n("Firm. rev. : "), m_messGroupBox);
  m_textLabel11 = new TQLabel( "", m_messGroupBox);
  TQToolTip::add(m_textLabelFirm,m_textLabelFirm->text());

  m_firmLayout = new TQHBoxLayout(messLayout);
  m_firmLayout->addWidget(m_textLabelFirm);
  m_firmLayout->addWidget(m_textLabel11);
  m_firmLayout->addStretch(20);
  m_firmLayout->setMargin ( 3 );
  
  
  m_valGroupBox = new TQGroupBox(this);
  m_mainLayout->addWidget(m_valGroupBox);
  m_valGroupBox->setFrameStyle( TQFrame::Panel + TQFrame::Raised);
//  m_bulbsGroupBox->setFrameStyle( TQFrame::Panel + TQFrame::Sunken);
  m_valGroupBox->setLineWidth(2);
  TQVBoxLayout* valLayout = new TQVBoxLayout(m_valGroupBox);
  valLayout->setMargin( 3 );

  
  
  m_textLabelRun = new TQLabel( i18n("Runtime")+" : ", m_valGroupBox);
  TQToolTip::add(m_textLabelRun,m_textLabelRun->text());

  m_LCDNumber1 = new TQLCDNumber (5,m_valGroupBox);
  m_LCDNumber1->setSegmentStyle (TQLCDNumber::Flat);
  m_LCDNumber1->setFrameStyle( TQFrame::NoFrame );
  m_LCDNumber1->setMinimumSize(50,20);

  m_runLayout = new TQHBoxLayout(valLayout);
  m_runLayout->addWidget(m_textLabelRun);
  m_runLayout->addStretch(20);
  m_runLayout->addWidget(m_LCDNumber1);
  m_runLayout->setMargin ( 5 );

  m_mainLayout->addStretch(20);
  m_mainLayout->addSpacing(5);

  setAllPalettes();

  changePanelFont();
  paintPanel ();

  }

KNutFrontPanel::~KNutFrontPanel(){
  }


//************************************************************

void KNutFrontPanel::paintPanel( void ) {

  if (m_panelFlags & PBOnLine) {
    m_textLabel1->show();
    m_frameOL->show();
    }
  else {
    m_textLabel1->hide();
    m_frameOL->hide();
    }

  if (m_panelFlags & PBOnBatt) {
    m_textLabel2->show();
    m_frameOB->show();
    }
  else {
    m_textLabel2->hide();
    m_frameOB->hide();
    }

  if (m_panelFlags & PBOver) {
    m_OLayout->setMargin ( 3 );
    m_textLabel3->show();
    m_frameOVER->show();
    }
  else {
    m_textLabel3->hide();
    m_frameOVER->hide();
    m_OLayout->setMargin ( 0 );
    }

  if (m_panelFlags & PBBattLow) {
    m_textLabel4->show();
    m_frameLB->show();
    m_LBLayout->setMargin ( 3 );
    }
  else {
    m_textLabel4->hide();
    m_frameLB->hide();
    m_LBLayout->setMargin ( 0 );
    }

  if (m_panelFlags & PBRepBatt) {
    m_textLabel5->show();
    m_frameRB->show();
    m_RBLayout->setMargin ( 3 );
    }
  else {
    m_textLabel5->hide();
    m_frameRB->hide();
    m_RBLayout->setMargin ( 0 );
    }

  if (m_panelFlags & PBCal) {
    m_textLabel6->show();
    m_frameCAL->show();
    m_CALLayout->setMargin ( 3 );
    }
  else {
    m_textLabel6->hide();
    m_frameCAL->hide();
    m_CALLayout->setMargin ( 0 );
    }

  if (m_panelFlags & PBMFRMod) {
    m_textLabel7->show();
    m_manufacModelLayout->setMargin ( 5 );
    }
  else {
    m_textLabel7->hide();
    m_manufacModelLayout->setMargin ( 0 );
    }


  if (m_panelFlags & PBMFR) {
    m_textLabel8->show();
    m_textLabelManufac->show();
    m_manufacLayout->setMargin ( 5 );
    }
  else {
    m_textLabel8->hide();
    m_textLabelManufac->hide();
    m_manufacLayout->setMargin ( 0 );
    }

  if (m_panelFlags & PBModel) {
    m_textLabel9->show();
    m_textLabelName->show();
    m_nameLayout->setMargin ( 5 );
    }
  else {
    m_textLabel9->hide();
    m_textLabelName->hide();
    m_nameLayout->setMargin ( 0 );
    }

  if (m_panelFlags & PBSerial) {
    m_textLabel10->show();
    m_textLabelSerial->show();
    m_serialLayout->setMargin ( 5 );
    }
  else {
    m_textLabel10->hide();
    m_textLabelSerial->hide();
    m_serialLayout->setMargin ( 0 );
    }

  if (m_panelFlags & PBFirm) {
    m_textLabel11->show();
    m_textLabelFirm->show();
    m_firmLayout->setMargin ( 5 );
    }
  else {
    m_textLabel11->hide();
    m_textLabelFirm->hide();
    m_firmLayout->setMargin ( 0 );
    }

if ( (m_panelFlags & PBMFRMod) || (m_panelFlags & PBMFR) || (m_panelFlags & PBModel) || (m_panelFlags & PBSerial) ||(m_panelFlags & PBFirm))    
   m_messGroupBox->show();
else
  m_messGroupBox->hide();
      
  if (m_panelFlags & PBRun) {
//    LCDNumber1->show();
//    textLabelRun->show();
//    runLayout->setMargin ( 5 );
    m_valGroupBox->show();
    }
  else {
//    LCDNumber1->hide();
//    textLabelRun->hide();
//    runLayout->setMargin ( 0 );
    m_valGroupBox->hide();
    }
  }


int KNutFrontPanel::getPanelHeight( void) { return 0; }  ///// correct !!!!!!!!

unsigned int KNutFrontPanel::getPanelFlags( void) { return m_panelFlags; }

void KNutFrontPanel::setPanelFlags(const int upsPanelFlags) { m_panelFlags = upsPanelFlags; }

void KNutFrontPanel::setAllNameUps(const TQString panelUpsAllName ){
  m_textLabel7->setText(panelUpsAllName);
  TQToolTip::remove(m_textLabel7);
  TQToolTip::add(m_textLabel7,panelUpsAllName);
  }

void KNutFrontPanel::setMFRUps(const TQString panelUpsFRM ){
  m_textLabel8->setText(panelUpsFRM);
  TQToolTip::remove(m_textLabelManufac);
  TQToolTip::add(m_textLabelManufac,m_textLabelManufac->text()+panelUpsFRM);
  }

void KNutFrontPanel::setNameUps(const TQString panelUpsName ){
  m_textLabel9->setText(panelUpsName);
  TQToolTip::remove(m_textLabelName);
  TQToolTip::add(m_textLabelName,m_textLabelName->text()+panelUpsName);
  }

void KNutFrontPanel::setSerialUps(const TQString panelUpsSerial ){
  m_textLabel10->setText(panelUpsSerial);
  TQToolTip::remove(m_textLabelSerial);
  TQToolTip::add(m_textLabelSerial,m_textLabelSerial->text()+panelUpsSerial);
  }

void KNutFrontPanel::setFirmRevUps(const TQString upsPanelFormRev ){
  m_textLabel11->setText(upsPanelFormRev);
  TQToolTip::remove(m_textLabelFirm);
  TQToolTip::add(m_textLabelFirm,m_textLabelFirm->text()+upsPanelFormRev);
  }


void KNutFrontPanel::cleanPanel(void) {
  m_textLabel7->setText("");
  m_textLabel8->setText("");
  m_textLabel9->setText("");
  m_textLabel10->setText("");
  m_textLabel11->setText("");

  m_frameOL->setColor(m_upsBackColor);
  m_frameOL->off();
  m_frameOB->setColor(m_upsBackColor);
  m_frameOB->off();
  m_frameOVER->setColor(m_upsBackColor);
  m_frameOVER->off();
  m_frameLB->setColor(m_upsBackColor);
  m_frameLB->off();
  m_frameRB->setColor(m_upsBackColor);
  m_frameRB->off();
  m_frameCAL->setColor(m_upsBackColor);
  m_frameCAL->off();

  m_LCDNumber1->display("-:--");
  m_LCDNumber1->setPalette (palette());
  }

void KNutFrontPanel::setRuntime(const int runtime) {
  TQString runtimeString;

  if (runtime != knc::numberVarError) {
    int min = (int)floor(runtime/60);
    int sec = runtime - (min*60);
    runtimeString=TQString("%1:%2").arg(min,2).arg(sec,2);
    if (runtimeString[3] == ' ') runtimeString[3]='0';
    }
  else runtimeString="-:--";  

  m_LCDNumber1->display(runtimeString);
  }

  

void KNutFrontPanel::setPanel(const int panelBulbs) {
//  OFF			- 1 ups je vypnuta
//  OL			- 2 ups je bezi na sit
//  OB			- 4 ups bezi na baterie
//  LB			- 8 baterie je vybyta (pokud je zaroven OB dojde k shutdownu)
//  CAL			- 16 je spustena calibrace
//  OVER		- 128 ups je pretizena
//  RB			- 256 ups pozaduje vymenu baterie


  if (!(panelBulbs < 0)) {
    // ups online /na sit
    if (panelBulbs & KNutNet::OL) {
      m_frameOL->setColor(m_upsOkColor);
      m_frameOL->on();
      m_LCDNumber1->setPalette (m_LCDPaletteOk);
      m_typeOfLCDColor=true;
      }
    else {
      m_frameOL->setColor(m_upsBackColor);
      m_frameOL->off();
      }

    // ups ofline /na baterie
    if (panelBulbs & KNutNet::OB) {
      m_frameOB->setColor(m_upsErrorColor);
      m_frameOB->on();
      m_LCDNumber1->setPalette (m_LCDPaletteErr);
      m_typeOfLCDColor=false;
      }
    else {
      m_frameOB->setColor(m_upsBackColor);
      m_frameOB->off();
      }

    if (panelBulbs & KNutNet::LB) {
      m_frameLB->setColor(m_upsErrorColor);
      m_frameLB->on();
      }
    else {
      m_frameLB->setColor(m_upsBackColor);
      m_frameLB->off();
      }

    if (panelBulbs & KNutNet::OVER) {
      m_frameOVER->setColor(m_upsErrorColor);
      m_frameOVER->on();
      }
    else {
      m_frameOVER->setColor(m_upsBackColor);
      m_frameOVER->off();
      }

    if (panelBulbs & KNutNet::RB) {
      m_frameRB->setColor(m_upsErrorColor);
      m_frameRB->on();
      }
    else {
      m_frameRB->setColor(m_upsBackColor);
      m_frameRB->off();
      }

    if (panelBulbs & KNutNet::CAL) {
      m_frameCAL->setColor(m_upsErrorColor);
      m_frameCAL->on();
      }
    else {
      m_frameCAL->setColor(m_upsBackColor);
      m_frameCAL->off();
      }
    }
  }

  
/*********************************************************************************************/
/*                                                                                           */
/*                         PUBLIC SLOTS                                                      */
/*                                                                                           */
/*********************************************************************************************/
  
  
void KNutFrontPanel::slotSetPanelFont(TQFont newPanelFont) {

  m_panelFont = newPanelFont; // nastavime font
  m_panelBoldFont = newPanelFont; // pozdeji zmenime

  m_panelBoldFont.setBold (true);
  m_panelFont.setBold (false); // Zrusime bold u panelu

  changePanelFont(); // zmeni pismo
  paintPanel();
  }

  
/*********************************************************************************************/
/*                                                                                           */
/*                         PRIVATE FUNCTIONS                                                 */
/*                                                                                           */
/*********************************************************************************************/
  
  
void KNutFrontPanel::setLCDPalette (void) {
  m_LCDPaletteOk = m_myPalette;
  m_LCDPaletteErr = m_myPalette;
  //Nastavime barvu pro OK system je online
  TQColorGroup activeColorGroup = m_LCDPaletteOk.active();
  activeColorGroup.setColor( TQColorGroup::Foreground, green);

  m_LCDPaletteOk.setActive(activeColorGroup);
  m_LCDPaletteOk.setInactive(activeColorGroup);

  //Nastavime Barvu pro Error - System neni online
  activeColorGroup = m_LCDPaletteErr.active();
  activeColorGroup.setColor( TQColorGroup::Foreground, red);
  m_LCDPaletteErr.setActive(activeColorGroup);
  m_LCDPaletteErr.setInactive(activeColorGroup);
  }

void KNutFrontPanel::setPalette (const TQPalette & p){

  m_myPalette = p;
  setAllPalettes();
  }

      
void KNutFrontPanel::setAllPalettes (void){
  TQColor myColor;

  TQFrame::setPalette (m_myPalette);
  //TQColorGroup myColorGroup = myPalette.active();
  
//  LCDPaletteOk = myPalette;
//  LCDPaletteErr = myPalette;

  setLCDPalette();
  
  m_bulbsPalette = m_myPalette;

  m_frameOL->setPalette(m_bulbsPalette);

  // we must correct feature of KLed, KLed repaint background when color of item (function KLed::setColor()) is changed only
  // when we change palette backround only, KLed ignore this change
    
  myColor = m_frameOL->color();
  m_frameOL->setColor(m_helpColor); // black is neutral (unprofitable) color for us 
  m_frameOL->setColor(myColor); 

  myColor = m_frameOB->color();
  m_frameOB->setColor(m_helpColor);
  m_frameOB->setColor(myColor);
  
  myColor = m_frameLB->color();
  m_frameLB->setColor(m_helpColor);
  m_frameLB->setColor(myColor);

  myColor = m_frameOVER->color();
  m_frameOVER->setColor(m_helpColor);
  m_frameOVER->setColor(myColor);

  myColor = m_frameRB->color();
  m_frameRB->setColor(m_helpColor);
  m_frameRB->setColor(myColor);

  myColor = m_frameCAL->color();
  m_frameCAL->setColor(m_helpColor);
  m_frameCAL->setColor(myColor);
        
  
  if (m_LCDNumber1) {
    if (m_typeOfLCDColor)
      m_LCDNumber1->setPalette (m_LCDPaletteOk);
    else
      m_LCDNumber1->setPalette (m_LCDPaletteErr);
    }
  }

void KNutFrontPanel::changePanelFont (void) {
  m_textLabel1->setFont(m_panelFont);
  m_textLabel2->setFont(m_panelFont);
  m_textLabel3->setFont(m_panelFont);
  m_textLabel4->setFont(m_panelFont);
  m_textLabel5->setFont(m_panelFont);
  m_textLabel6->setFont(m_panelFont);

  m_textLabelManufac->setFont(m_panelFont);
  m_textLabelName->setFont (m_panelFont);
  m_textLabelSerial->setFont (m_panelFont);
  m_textLabelFirm->setFont (m_panelFont);
  m_textLabelRun->setFont (m_panelFont);
  m_textLabel7->setFont (m_panelBoldFont);
  m_textLabel8->setFont (m_panelBoldFont);
  m_textLabel9->setFont (m_panelBoldFont);
  m_textLabel10->setFont (m_panelBoldFont);
  m_textLabel11->setFont (m_panelBoldFont);
  m_textLabelRun->setFont (m_panelFont);
  }

  
#include "knutfrontpanel.moc"  
