/***************************************************************************
    smb4kbookmarkeditor  -  This is the bookmark editor of Smb4K.
                             -------------------
    begin                : Di Okt 5 2004
    copyright            : (C) 2004-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// TQt includes
#include <tqlayout.h>
#include <tqvaluelist.h>

// KDE includes
#include <tdelocale.h>
#include <tdeaction.h>
#include <tdeactionclasses.h>
#include <tdeaccel.h>
#include <kiconloader.h>
#include <tdeconfig.h>
#include <tdemessagebox.h>
#include <tdeapplication.h>
#include <tdepopupmenu.h>

// application specific includes
#include "smb4kbookmarkeditor.h"
#include "../core/smb4kbookmark.h"
#include "../core/smb4kcore.h"
#include "../core/smb4tdeglobal.h"
#include "../core/smb4ksettings.h"

using namespace Smb4TDEGlobal;


Smb4KBookmarkEditor::Smb4KBookmarkEditor( TQWidget *parent, const char *name )
: KDialogBase( Plain, i18n( "Bookmark Editor" ), Ok|Cancel, Ok, parent, name, true, true )
{
  setWFlags( TQt::WDestructiveClose );

  TQFrame *frame = plainPage();
  TQGridLayout *layout = new TQGridLayout( frame );
  layout->setSpacing( 5 );

  m_view = new TDEListView( frame );
  m_view->addColumn( i18n( "Bookmark" ), Bookmark );
  m_view->addColumn( i18n( "Workgroup" ), Workgroup );
  m_view->addColumn( i18n( "IP Address" ), IPAddress );
  m_view->addColumn( i18n( "Label" ), Label );
//   m_view->setAllColumnsShowFocus( true );
  m_view->setItemsRenameable( true );
  m_view->setRenameable( Bookmark, false );
  m_view->setRenameable( Workgroup, false );
  m_view->setRenameable( IPAddress, true );
  m_view->setRenameable( Label, true );

  m_collection = new TDEActionCollection( this, "BookmarkEditor_ActionCollection", TDEGlobal::instance() );

  (void) new TDEAction( i18n( "&Remove" ), "remove", Key_Delete, this, TQ_SLOT( slotRemoveClicked() ), m_collection, "remove_bookmark" );

  (void) new TDEAction( i18n( "Remove &All" ), "edit-delete", CTRL+Key_X, this, TQ_SLOT( slotDeleteAllClicked() ), m_collection, "remove_all_bookmarks" );

  slotLoadBookmarks();

  layout->addWidget( m_view, 0, 0, 0 );

  setInitialSize( configDialogSize( *(Smb4KSettings::self()->config()), "BookmarkEditor" ) );
  setMinimumSize( (sizeHint().width() > 350 ? sizeHint().width() : 350), sizeHint().height() );

  connect( m_view,                       TQ_SIGNAL( rightButtonPressed( TQListViewItem *, const TQPoint &, int ) ),
           this,                         TQ_SLOT( slotRightButtonPressed( TQListViewItem *, const TQPoint &, int ) ) );

  connect( m_view,                       TQ_SIGNAL( itemRenamed( TQListViewItem * ) ),
           this,                         TQ_SLOT( slotItemRenamed( TQListViewItem * ) ) );

  connect( this,                         TQ_SIGNAL( okClicked() ),
           this,                         TQ_SLOT( slotOkClicked() ) );

  connect( this,                         TQ_SIGNAL( cancelClicked() ),
           this,                         TQ_SLOT( slotCancelClicked() ) );

  connect( Smb4KCore::bookmarkHandler(), TQ_SIGNAL( bookmarksUpdated() ),
           this,                         TQ_SLOT( slotLoadBookmarks() ) );
}


Smb4KBookmarkEditor::~Smb4KBookmarkEditor()
{
  uint index = 0;

  while ( index < m_collection->count() )
  {
    delete m_collection->action( index++ );
  }

  m_collection->clear();
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KBookmarkEditor::slotRightButtonPressed( TQListViewItem *item, const TQPoint &pos, int )
{
  if ( !item )
  {
    m_collection->action( "remove_bookmark" )->setEnabled( false );
  }
  else
  {
    m_collection->action( "remove_bookmark" )->setEnabled( true );
  }

  if ( m_view->childCount() == 0 )
  {
    m_collection->action( "remove_all_bookmarks" )->setEnabled( false );
  }
  else
  {
    m_collection->action( "remove_all_bookmarks" )->setEnabled( true );
  }

  TDEActionMenu *menu = static_cast<TDEActionMenu *>( child( "BookmarkEditorPopupMenu", "TDEActionMenu", true ) );

  if ( !menu )
  {
    menu = new TDEActionMenu( this, "BookmarkEditorPopupMenu" );
    menu->insert( m_collection->action( "remove_bookmark" ) );
    menu->insert( m_collection->action( "remove_all_bookmarks" ) );
  }

  menu->popup( pos );
}


void Smb4KBookmarkEditor::slotRemoveClicked()
{
  if ( m_view->currentItem() )
  {
    delete m_view->currentItem();
  }

  // Adjust the columns:
  for ( int col = 0; col < m_view->columns(); col++ )
  {
    m_view->adjustColumn( col );
  }
}


void Smb4KBookmarkEditor::slotDeleteAllClicked()
{
  m_view->clear();

  // Adjust the columns:
  for ( int col = 0; col < m_view->columns(); col++ )
  {
    m_view->adjustColumn( col );
  }
}


void Smb4KBookmarkEditor::slotOkClicked()
{
  TDEActionPtrList list = m_collection->actions( "BookmarkEditor" );

  for ( TDEActionPtrList::Iterator it = list.begin(); it != list.end(); ++it )
  {
    delete *it;
  }

  TQValueList<Smb4KBookmark *> bookmarks;

  if ( m_view->childCount() != 0 )
  {
    TQListViewItemIterator it( m_view );

    while( it.current() )
    {
      bookmarks.append( new Smb4KBookmark(
                         it.current()->text( Bookmark ).section( "/", 2, 2 ).stripWhiteSpace(),
                         it.current()->text( Bookmark ).section( "/", 3, 3 ).stripWhiteSpace(),
                         it.current()->text( Workgroup ).stripWhiteSpace(),
                         it.current()->text( IPAddress ).stripWhiteSpace(),
                         "Disk",
                         it.current()->text( Label ).stripWhiteSpace() ) );
      ++it;
    }
  }

  Smb4KCore::bookmarkHandler()->writeBookmarkList( bookmarks );

  saveDialogSize( *(Smb4KSettings::self()->config()), "BookmarkEditor" );
}


void Smb4KBookmarkEditor::slotCancelClicked()
{
  TDEActionPtrList list = m_collection->actions( "BookmarkEditor" );

  for ( TDEActionPtrList::Iterator it = list.begin(); it != list.end(); ++it )
  {
    m_collection->tdeaccel()->remove( (*it)->name() );
    m_collection->remove( *it );
  }
}


void Smb4KBookmarkEditor::slotLoadBookmarks()
{
  m_view->clear();

  TQValueList<Smb4KBookmark *> bookmarks = Smb4KCore::bookmarkHandler()->getBookmarks();

  for ( TQValueList<Smb4KBookmark *>::ConstIterator it = bookmarks.begin(); it != bookmarks.end(); ++it )
  {
    TDEListViewItem *item = new TDEListViewItem( m_view );
    item->setText( Bookmark, (*it)->bookmark() );
    item->setText( Workgroup, (*it)->workgroup() );
    item->setText( IPAddress, (*it)->ip() );
    item->setText( Label, (*it)->label() );
    item->setPixmap( Bookmark, SmallIcon( "folder" ) );
  }

  // Adjust the columns:
  for ( int col = 0; col < m_view->columns(); col++ )
  {
    m_view->adjustColumn( col );
  }
}


void Smb4KBookmarkEditor::slotItemRenamed( TQListViewItem * )
{
  // Adjust the columns:
  for ( int col = 0; col < m_view->columns(); col++ )
  {
    m_view->adjustColumn( col );
  }
}

#include "smb4kbookmarkeditor.moc"
