#ifndef _KVI_TAL_ICONVIEW_QT3_H_
#define _KVI_TAL_ICONVIEW_QT3_H_

//=============================================================================
//
//   File : kvi_tal_iconview_qt3.h
//   Creation date : Mon Jan 22 2007 11:25:08 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2007 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_qstring.h"

#include <tqiconview.h>

class KviTalIconViewItem;


class KVILIB_API KviTalIconView : public TQIconView
{
	TQ_OBJECT
  
public:
	KviTalIconView(TQWidget * pParent,TQt::WFlags f = 0);
	virtual ~KviTalIconView() {};
signals:
	void selectionChanged(KviTalIconViewItem * pItem);
	void currentChanged(KviTalIconViewItem * pItem);
	void clicked(KviTalIconViewItem * pItem);
	void clicked(KviTalIconViewItem * pItem,const TQPoint &pnt);
	void pressed(KviTalIconViewItem * pItem);
	void pressed(KviTalIconViewItem * pItem,const TQPoint &pnt);
	void doubleClicked(KviTalIconViewItem * pItem);
	void returnPressed(KviTalIconViewItem * pItem);
	void rightButtonClicked(KviTalIconViewItem * pItem,const TQPoint &pnt);
	void rightButtonPressed(KviTalIconViewItem * pItem,const TQPoint &pnt);
	void mouseButtonClicked(int iButton,KviTalIconViewItem * pItem,const TQPoint &pnt);
	void mouseButtonPressed(int iButton,KviTalIconViewItem * pItem,const TQPoint &pnt);
	void contextMenuRequested(KviTalIconViewItem * pItem,const TQPoint &pnt);
	void onItem(KviTalIconViewItem * pItem);
protected slots:
	void redirect_selectionChanged(TQIconViewItem * pItem);
	void redirect_currentChanged(TQIconViewItem * pItem);
	void redirect_clicked(TQIconViewItem * pItem);
	void redirect_clicked(TQIconViewItem * pItem,const TQPoint &pnt);
	void redirect_pressed(TQIconViewItem * pItem);
	void redirect_pressed(TQIconViewItem * pItem,const TQPoint &pnt);
	void redirect_doubleClicked(TQIconViewItem * pItem);
	void redirect_returnPressed(TQIconViewItem * pItem);
	void redirect_rightButtonClicked(TQIconViewItem * pItem,const TQPoint &pnt);
	void redirect_rightButtonPressed(TQIconViewItem * pItem,const TQPoint &pnt);
	void redirect_mouseButtonClicked(int iButton,TQIconViewItem * pItem,const TQPoint &pnt);
	void redirect_mouseButtonPressed(int iButton,TQIconViewItem * pItem,const TQPoint &pnt);
	void redirect_contextMenuRequested(TQIconViewItem * pItem,const TQPoint &pnt);
	void redirect_onItem(TQIconViewItem * pItem);
public:
	KviTalIconViewItem * firstItem() const { return (KviTalIconViewItem *)TQIconView::firstItem(); };
	KviTalIconViewItem * lastItem() const { return (KviTalIconViewItem *)TQIconView::lastItem(); };
	KviTalIconViewItem * currentItem() const { return (KviTalIconViewItem *)TQIconView::currentItem(); };
};

class KVILIB_API KviTalIconViewItem : public TQIconViewItem
{
public:
	KviTalIconViewItem(KviTalIconView * parent)
	: TQIconViewItem(parent) {};
	KviTalIconViewItem(KviTalIconView * parent,KviTalIconViewItem * after)
	: TQIconViewItem(parent,after) {};
	KviTalIconViewItem(KviTalIconView * parent, const TQString & text)
	: TQIconViewItem(parent,text) {};
	KviTalIconViewItem(KviTalIconView * parent, KviTalIconViewItem * after, const TQString & text)
	: TQIconViewItem(parent,after,text) {};
	KviTalIconViewItem(KviTalIconView * parent, const TQString & text, const TQPixmap & icon)
	: TQIconViewItem(parent,text,icon) {};
	KviTalIconViewItem(KviTalIconView * parent, KviTalIconViewItem * after, const TQString & text, const TQPixmap & icon)
	: TQIconViewItem(parent,after,text,icon) {};
public:
	KviTalIconView * iconView() const { return (KviTalIconView *)TQIconViewItem::iconView(); };
	KviTalIconViewItem * prevItem() const { return (KviTalIconViewItem *)TQIconViewItem::prevItem(); };
	KviTalIconViewItem * nextItem() const { return (KviTalIconViewItem *)TQIconViewItem::nextItem(); };
};


#endif // _KVI_TAL_ICONVIEW_QT3_H_
