/*
 *  Copyright (c) 2005 Boudewijn Rempt <boud@valdyas.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#include <tqstringlist.h>
#include <tqdir.h>
#include <kstandarddirs.h>
#include <tdeglobal.h>

#include <config.h>
#include LCMS_HEADER

#include <kis_colorspace_factory_registry.h>
#include <kis_math_toolbox.h>
#include <kis_meta_registry.h>

KisMetaRegistry * KisMetaRegistry::m_singleton = 0;

KisMetaRegistry::KisMetaRegistry()
{
    // Create the colorspaces and load the profiles

    TDEGlobal::instance()->dirs()->addResourceType("kis_profiles",
                                                     TDEStandardDirs::kde_default("data") + "chalk/profiles/");
                          
    // Add those things here as well, since we are not yet using KisDoc's KisFactory instance (which inits these as well)
    TDEGlobal::instance()->dirs()->addResourceType("kis_profiles", TDEStandardDirs::kde_default("data") + "chalk/profiles/");
    TDEGlobal::instance()->dirs()->addResourceDir("kis_profiles", "/usr/share/color/icc");
    TDEGlobal::instance()->dirs()->addResourceDir("kis_profiles", TQDir::homeDirPath() + TQString("/.icc/"));
    TDEGlobal::instance()->dirs()->addResourceDir("kis_profiles", TQDir::homeDirPath() + TQString("/.color/icc/"));

    TQStringList profileFilenames;
    profileFilenames += TDEGlobal::instance()->dirs()->findAllResources("kis_profiles", "*.icm", true /* recursive */);
    profileFilenames += TDEGlobal::instance()->dirs()->findAllResources("kis_profiles", "*.ICM", true);
    profileFilenames += TDEGlobal::instance()->dirs()->findAllResources("kis_profiles", "*.ICC", true);
    profileFilenames += TDEGlobal::instance()->dirs()->findAllResources("kis_profiles", "*.icc", true);
    // Set lcms to return NUll/false etc from failing calls, rather than aborting the app.
    cmsErrorAction(LCMS_ERROR_SHOW);

    m_csRegistry = new KisColorSpaceFactoryRegistry(profileFilenames);
    m_mtRegistry = new KisMathToolboxFactoryRegistry();
}

KisMetaRegistry::~KisMetaRegistry()
{
}

KisMetaRegistry * KisMetaRegistry::instance()
{
    if ( KisMetaRegistry::m_singleton == 0 ) {
        KisMetaRegistry::m_singleton = new KisMetaRegistry();
    }
    return KisMetaRegistry::m_singleton;
}

