/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  begin:     Wed Sep 1 2004
  copyright: (C) 2004 by Gary Cramblitt
  email:     garycramblitt@comcast.net
*/

#include "editnotifydialog.h"
#include "konversationapplication.h"
#include "servergroupsettings.h"

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqwhatsthis.h>

#include <klineedit.h>
#include <kcombobox.h>
#include <kdebug.h>
#include <tdelocale.h>


EditNotifyDialog::EditNotifyDialog(TQWidget* parent,
const TQString& network,
const TQString& nickname):

KDialogBase(parent,"editnotify",true,i18n("Edit Watched Nickname"),
KDialogBase::Ok | KDialogBase::Cancel,
KDialogBase::Ok,true)

{
    TQWidget* page=new TQWidget(this);
    setMainWidget(page);

    TQHBoxLayout* layout = new TQHBoxLayout(page);
    layout->setSpacing(spacingHint());

    TQLabel* networkNameLabel=new TQLabel(i18n("&Network name:"),page);
    TQString networkNameWT = i18n(
        "Pick the server network you will connect to here.");
    TQWhatsThis::add(networkNameLabel, networkNameWT);
    m_networkNameCombo=new KComboBox(page,"notify_network_combo");
    TQWhatsThis::add(m_networkNameCombo, networkNameWT);
    networkNameLabel->setBuddy(m_networkNameCombo);

    TQLabel* nicknameLabel=new TQLabel(i18n("N&ickname:"),page);
    TQString nicknameWT = i18n(
        "<qt>The nickname to watch for when connected to a server in the network.</qt>");
    TQWhatsThis::add(nicknameLabel, nicknameWT);
    m_nicknameInput = new KLineEdit(nickname, page);
    TQWhatsThis::add(m_nicknameInput, nicknameWT);
    nicknameLabel->setBuddy(m_nicknameInput);

    // Build a list of unique server network names.
    // TODO: The "ServerGroupList type is a misnomer (it is actually networks), which
    // should be fixed at some point.
    Konversation::ServerGroupList serverNetworks = Preferences::serverGroupList();
    TQStringList networkNames;

    for(Konversation::ServerGroupList::iterator it = serverNetworks.begin(); it != serverNetworks.end(); ++it)
    {
        TQString name = (*it)->name();

        if (!networkNames.contains(name))
        {
            networkNames.append(name);
        }
    }

    networkNames.sort();
    // Add network names to network combobox and select the one corresponding to argument.
    for (TQStringList::ConstIterator it = networkNames.begin(); it != networkNames.end(); ++it)
    {
        m_networkNameCombo->insertItem(*it);
        if(*it == network) m_networkNameCombo->setCurrentItem(m_networkNameCombo->count()-1);
    }

    layout->addWidget(networkNameLabel);
    layout->addWidget(m_networkNameCombo);
    layout->addWidget(nicknameLabel);
    layout->addWidget(m_nicknameInput);

    setButtonOK(KGuiItem(i18n("&OK"),"button_ok",i18n("Change notify information")));
    setButtonCancel(KGuiItem(i18n("&Cancel"),"button_cancel",i18n("Discards all changes made")));
}

EditNotifyDialog::~EditNotifyDialog()
{
}

void EditNotifyDialog::slotOk()
{
    emit notifyChanged(m_networkNameCombo->currentText(),
        m_nicknameInput->text());
    delayedDestruct();
}

#include "editnotifydialog.moc"
