/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "profileracoonoptions.h"

#include <klineedit.h>
#include <tdelocale.h>
#include <kcombobox.h>
#include <tqcheckbox.h>
#include <tqtooltip.h>
#include <tqlabel.h>
#include "widgetnotifyhelper.h"
#include <iostream>

ProfileRacoonOptions::ProfileRacoonOptions(TQWidget *parent)
		: ProfileRacoonOptionsBase(parent)
{
	WidgetNotifyHelper h;
	h.setupChangedAction(this);
	dialogModified=false;

	TQToolTip::add( RemoteIdTypeCombobox, i18n("<b>Remote ID type</b><br><table>"
	"<tr><td>none:</td><td>No ID</td></tr>"
	"<tr><td>address:</td><td>The type is the IP address. This is the default type if you do not specify an identifier to use</td></tr>"
	"<tr><td>user_fqdn:</td><td>The type is a USER_FTQDN (user fully-qualified domain name)</td></tr>"
	"<tr><td>fqdn:</td><td>The type is a FTQDN (fully-qualified domain name)</td></tr>"
	"<tr><td>keyid (file):</td><td>The type is a KEY_ID, read from the file</td></tr>"
	"<tr><td>keyid:</td><td>The type is a KEY_ID, specified in field</td></tr>"
	"<tr><td>asn1dn:</td><td>The type is an ASN.1 distinguished name. If empty, DN from the Subject field in the certificate will be used"
	"<table>"));

	TQToolTip::add( LocalIdTypeCombobox, i18n("<b>Local ID type</b><br><table>"
	"<tr><td>none:</td><td>No ID</td></tr>"
	"<tr><td>address:</td><td>The type is the IP address. This is the default type if you do not specify an identifier to use</td></tr>"
	"<tr><td>user_fqdn:</td><td>The type is a USER_FTQDN (user fully-qualified domain name)</td></tr>"
	"<tr><td>fqdn:</td><td>The type is a FTQDN (fully-qualified domain name)</td></tr>"
	"<tr><td>keyid (file):</td><td>The type is a KEY_ID, read from the file</td></tr>"
	"<tr><td>keyid:</td><td>The type is a KEY_ID, specified in field</td></tr>"
	"<tr><td>asn1dn:</td><td>The type is an ASN.1 distinguished name. If empty, DN from the Subject field in the certificate will be used"
	"<table>"));


}


ProfileRacoonOptions::~ProfileRacoonOptions()
{}

void ProfileRacoonOptions::localIDTypeToggled(const TQString& text)
{
	if (text == "none")
	{
		LocalIDLineEdit->setDisabled(true);
		LocalIDLabel->setDisabled(true);
	}
	else
	{
		LocalIDLineEdit->setDisabled(false);
		LocalIDLabel->setDisabled(false);
	}
}

void ProfileRacoonOptions::dialogChanged()
{
// 	std::cout << "ProfileRacoonOptions::dialogChanged()" << std::endl;
	dialogModified=true;
}


void ProfileRacoonOptions::remoteIDTypeToggled(const TQString& text)
{
	if (text == "none")
	{
		RemoteIDLineEdit->setDisabled(true);
		RemoteIDLabel->setDisabled(true);
	}
	else
	{
		RemoteIDLineEdit->setDisabled(false);
		RemoteIDLabel->setDisabled(false);
	}
}

#include "profileracoonoptions.moc"
