/***************************************************************************
                          tderadiodisplay.h  -  description
                             -------------------
    begin                : Mit Jan 29 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRADIO_RADIOVIEW_FREQUENCYRADIO_H
#define KRADIO_RADIOVIEW_FREQUENCYRADIO_H

#include "../../src/include/radiodevice_interfaces.h"
#include "../../src/include/soundstreamclient_interfaces.h"
#include "radioview_element.h"
#include "displaycfg_interfaces.h"

/**
  *@author Martin Witte
  */

class RadioViewFrequencyRadio : public RadioViewElement,  // is a TQObject, must be first
                                public IRadioDeviceClient,
                                public IFrequencyRadioClient,
                                public ISoundStreamClient,
                                public IDisplayCfg
{
TQ_OBJECT
  
public:
    RadioViewFrequencyRadio(TQWidget *parent, const TQString &name);
    ~RadioViewFrequencyRadio();

    float getUsability (Interface *) const;

    virtual void   saveState (TDEConfig *) const;
    virtual void   restoreState (TDEConfig *);

    ConfigPageInfo createConfigurationPage();

// Interface

    bool connectI   (Interface *);
    bool disconnectI(Interface *);

// IDisplayCfg

RECEIVERS:
    bool  setDisplayColors(const TQColor &activeColor, const TQColor &inactiveColor, const TQColor &bkgnd);
    bool  setDisplayFont (const TQFont &f);

ANSWERS:
    const TQColor   &getDisplayActiveColor()   const { return m_colorActiveText; }
    const TQColor   &getDisplayInactiveColor() const { return m_colorInactiveText; }
    const TQColor   &getDisplayBkgndColor()    const { return m_colorButton; }
    const TQFont    &getDisplayFont()          const { return m_font; }

// IRadioDeviceClient
RECEIVERS:
    bool noticePowerChanged   (bool on, const IRadioDevice *sender = NULL);
    bool noticeStationChanged (const RadioStation &, const IRadioDevice *sender = NULL);
    bool noticeDescriptionChanged (const TQString &, const IRadioDevice *sender = NULL);
    bool noticeCurrentSoundStreamIDChanged(SoundStreamID /*id*/, const IRadioDevice */*sender*/) { return false; }

// ISoundStreamClient
RECEIVERS:
    void noticeConnectedI (ISoundStreamServer *s, bool pointer_valid);

    bool noticeSignalQualityChanged(SoundStreamID id, float q);
    bool noticeStereoChanged(SoundStreamID id, bool  s);

// IFrequencyRadioClient
RECEIVERS:
    bool noticeFrequencyChanged(float f, const RadioStation *s);
    bool noticeMinMaxFrequencyChanged(float min, float max);
    bool noticeDeviceMinMaxFrequencyChanged(float min, float max);
    bool noticeScanStepChanged(float s);

// own stuff ;)

public:

    void reparent (TQWidget *parent, WFlags f, const TQPoint &p, bool showIt = false);

protected:

    void drawContents(TQPainter *p);

protected:

    TQColor  m_colorActiveText, m_colorInactiveText, m_colorButton;
    TQFont   m_font;

    bool  m_power;
    bool  m_valid;
    float m_frequency;
    float m_quality;
    bool  m_stereo;
};

#endif
