/***************************************************************************
                          displaycfg_interfaces.h  -  description
                             -------------------
    begin                : Fr Aug 15 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRADIO_DISPLAYCFG_INTERFACES_H
#define KRADIO_DISPLAYCFG_INTERFACES_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "../../src/include/interfaces.h"

#include <tqfont.h>
#include <tqcolor.h>

///////////////////////////////////////////////////////////////////////


INTERFACE(IDisplayCfg, IDisplayCfgClient)
{
public :
    IF_CON_DESTRUCTOR(IDisplayCfg, -1)

RECEIVERS:
    IF_RECEIVER(  setDisplayColors(const TQColor &activeColor, const TQColor &inactiveColor, const TQColor &bkgnd) )
    IF_RECEIVER(  setDisplayFont  (const TQFont &f)                                                             )

SENDERS:
    IF_SENDER  (  notifyDisplayColorsChanged(const TQColor &activeColor, const TQColor &inactiveColor, const TQColor &bkgnd) )
    IF_SENDER  (  notifyDisplayFontChanged(const TQFont &f)                                                               )

ANSWERS:
    IF_ANSWER  (  const TQColor   &getDisplayActiveColor() const )
    IF_ANSWER  (  const TQColor   &getDisplayInactiveColor() const )
    IF_ANSWER  (  const TQColor   &getDisplayBkgndColor() const )
    IF_ANSWER  (  const TQFont    &getDisplayFont() const )

};


INTERFACE(IDisplayCfgClient, IDisplayCfg)
{
friend class IDisplayCfg;

public :
    IF_CON_DESTRUCTOR(IDisplayCfgClient, 1)

SENDERS:
    IF_SENDER  (  sendDisplayColors(const TQColor &activeColor, const TQColor &inactiveColor, const TQColor &bkgnd) )
    IF_SENDER  (  sendDisplayFont  (const TQFont &f)                                                             )

RECEIVERS:
    IF_RECEIVER(  noticeDisplayColorsChanged(const TQColor &activeColor, const TQColor &inactiveColor, const TQColor &bkgnd) )
    IF_RECEIVER(  noticeDisplayFontChanged(const TQFont &f)                                                               )

QUERIES:
    IF_QUERY   (  const TQColor   &queryDisplayActiveColor() )
    IF_QUERY   (  const TQColor   &queryDisplayInactiveColor() )
    IF_QUERY   (  const TQColor   &queryDisplayBkgndColor()  )
    IF_QUERY   (  const TQFont    &queryDisplayFont()  )

RECEIVERS:
    virtual void noticeConnectedI    (cmplInterface *, bool pointer_valid);
    virtual void noticeDisconnectedI (cmplInterface *, bool pointer_valid);
};


#endif
