/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2007-11-25
 * Description : a bar used to search a string.
 * 
 * Copyright (C) 2007-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef SEARCH_TEXT_BAR_H
#define SEARCH_TEXT_BAR_H

// TQt includes.

#include <tqwidget.h>
#include <tqstring.h>

// KDE includes.

#include <klineedit.h>
#include <tdelocale.h>

// Local includes.

#include "digikam_export.h"

namespace Digikam
{

class DLineEditPriv;
class SearchTextBarPriv;

class DIGIKAM_EXPORT DLineEdit : public KLineEdit
{
    TQ_OBJECT
  

public:

    DLineEdit(const TQString &msg, TQWidget *parent);
    ~DLineEdit();

    void    setMessage(const TQString &msg);
    TQString message() const;

    void setText(const TQString& txt);

protected:

    void drawContents(TQPainter *p);
    void dropEvent(TQDropEvent *e);
    void focusInEvent(TQFocusEvent *e);
    void focusOutEvent(TQFocusEvent *e);

private :

    DLineEditPriv* d;
};

class DIGIKAM_EXPORT SearchTextBar : public TQWidget
{
TQ_OBJECT
  

public:

    SearchTextBar(TQWidget *parent, const char* name, const TQString &msg=i18n("Search..."));
    ~SearchTextBar();

    void setText(const TQString& text);
    TQString text() const;

    void setEnableTextQueryCompletion(bool b);
    bool textQueryCompletion() const;

    DLineEdit *lineEdit() const;

signals:

    void signalTextChanged(const TQString&);

public slots:

    void slotSearchResult(bool);

private slots:

    void slotTextChanged(const TQString&);

private :

    SearchTextBarPriv* d;
};

}  // namespace Digikam

#endif /* SEARCH_TEXT_BAR_H */
