/*
 * setupdlg.h
 * Copyright (C) 1999-2001 Kurt Granroth <granroth@kde.org>
 *
 * This file contains the setup dialog and related widgets
 * for KBiff.  All user configuration is done here.
 *
 * $Id$
 */
#ifndef SETUPDLG_H
#define SETUPDLG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif //HAVE_CONFIG_H

#include <kbiffurl.h>

#include <tqlistview.h>

#include <tqwidget.h>
#include <kdialog.h>
#include <tqdict.h>
#include <tqlineedit.h>

class TQLineEdit;
class TQCheckBox;
class TQPushButton;
class TQComboBox;

#include <kicondialog.h>

struct KBiffMailbox
{
  KBiffURL url;
  bool store;
  TQString key;
};

class KBiffGeneralTab;
class KBiffNewMailTab;
class KBiffMailboxTab;
class KBiffAboutTab;
class KBiffNewDlg;

class KBiffSetup : public KDialog
{
	TQ_OBJECT
public:
	KBiffSetup(const TQString& name = TQString::null, bool secure = false);
	virtual ~KBiffSetup();

	const TQString getProfile() const;
	const KBiffURL getCurrentMailbox() const;
	const TQPtrList<KBiffMailbox> getMailboxList() const;

	const TQString getMailClient() const;
	const TQString getRunCommandPath() const;
	const TQString getRunResetCommandPath() const;
	const TQString getPlaySoundPath() const;
	const TQString getNoMailIcon() const;
	const TQString getNewMailIcon() const;
	const TQString getOldMailIcon() const;
	const TQString getNoConnIcon() const;
	const TQString getStoppedIcon() const;
	bool getSystemBeep() const;
	bool getRunCommand() const;
	bool getRunResetCommand() const;
	bool getPlaySound() const;
	bool getNotify() const;
	bool getStatus() const;
	bool getDock() const;
	bool getSessionManagement() const;
	bool getCheckStartup() const;
	bool getSecure() const;
	unsigned int getPoll() const;

public slots:
	void invokeHelp();

	void readConfig(const TQString& profile);
	void saveConfig();

protected:
	TQString getSomeProfile() const;

protected slots:
	void slotDone();
	void slotAddNewProfile();
	void slotRenameProfile();
	void slotDeleteProfile();

private:
	bool isSecure;

	// "outer" dialog
	TQComboBox   *comboProfile;

	// tabs
	KBiffGeneralTab *generalTab;
	KBiffNewMailTab *newmailTab;
	KBiffMailboxTab *mailboxTab;
	KBiffAboutTab   *aboutTab;
};

class KBiffGeneralTab : public TQWidget
{
	TQ_OBJECT
public:
	KBiffGeneralTab(const TQString& profile = TQString::null, TQWidget *parent=0);
	virtual ~KBiffGeneralTab();

	const TQString getButtonNewMail() const;
	const TQString getButtonOldMail() const;
	const TQString getButtonNoMail() const;
	const TQString getButtonNoConn() const;
	const TQString getButtonStopped() const;
	const TQString getMailClient() const;
	int   getPoll() const;
	bool  getDock() const;
	bool  getSessionManagement() const;
	bool  getCheckStartup() const;

public slots:
	void readConfig(const TQString& profile);
	void saveConfig(const TQString& profile);

private:
	TQLineEdit* editPoll;
	TQLineEdit* editCommand;
	TQCheckBox* checkDock;
	TQCheckBox* checkNoSession;
	TQCheckBox* checkNoStartup;

	TDEIconButton *buttonNoMail;
	TDEIconButton *buttonOldMail;
	TDEIconButton *buttonNewMail;
	TDEIconButton *buttonNoConn;
	TDEIconButton *buttonStopped;
};

class KBiffNewMailTab : public TQWidget
{
	TQ_OBJECT
public:
	KBiffNewMailTab(const TQString& profile = TQString::null, TQWidget *parent=0);
	virtual ~KBiffNewMailTab();

	bool getRunCommand() const;
	const TQString getRunCommandPath() const;
	bool getRunResetCommand() const;
	const TQString getRunResetCommandPath() const;
	bool getPlaySound() const;
	const TQString getPlaySoundPath() const;
	bool getSystemBeep() const;
	bool getNotify() const;
	bool getStatus() const;

public slots:
	void readConfig(const TQString& profile);
	void saveConfig(const TQString& profile);

protected slots:
	void enableRunCommand(bool);
	void enableRunResetCommand(bool);
	void enablePlaySound(bool);
	void browseRunCommand();
	void browseRunResetCommand();
	void browsePlaySound();
	void testPlaySound();

private:
	TQLineEdit *editRunCommand;
	TQLineEdit *editRunResetCommand;
	TQLineEdit *editPlaySound;

	TQCheckBox *checkRunCommand;
	TQCheckBox *checkRunResetCommand;
	TQCheckBox *checkPlaySound;
	TQCheckBox *checkBeep;
	TQCheckBox *checkNotify;
	TQCheckBox *checkStatus;

	TQPushButton *buttonBrowsePlaySound;
	TQPushButton *buttonTestPlaySound;
	TQPushButton *buttonBrowseRunCommand;
	TQPushButton *buttonBrowseRunResetCommand;
};

class KBiffMailboxAdvanced : public KDialog
{
	TQ_OBJECT
public:
	KBiffMailboxAdvanced();
	virtual ~KBiffMailboxAdvanced();

	const KBiffURL getMailbox() const;
	unsigned int getPort() const;
	bool getPreauth() const;

	void setPort(unsigned int the_port, bool enable = true);
	void setTimeout(unsigned int the_to, bool enable = true);
	void setMailbox(const KBiffURL& url);
	void setPreauth(bool on);
	void setKeepalive(bool on);
	void setAsync(bool on);
	void setDisableApop(bool on);

protected slots:
	void portModified(const TQString& text);
	void timeoutModified(const TQString& text);
	void preauthModified(bool toggled);
	void keepaliveModified(bool toggled);
	void asyncModified(bool toggled);
    void apopModified(bool toggled);

private:
	TQString    password;
	TQLineEdit *mailbox;
	TQLineEdit *port;
	TQLineEdit *timeout;
	TQCheckBox *preauth;
	TQCheckBox *keepalive;
	TQCheckBox *async;
    TQCheckBox *apop;
};

class KBiffMailboxTab : public TQWidget
{
	TQ_OBJECT
public:
	KBiffMailboxTab(const TQString& profile = TQString::null, TQWidget *parent=0);
	virtual ~KBiffMailboxTab();

	void setMailbox(const KBiffURL& url);

	const KBiffURL getMailbox() const;
	const TQPtrList<KBiffMailbox> getMailboxList() const;

public slots:
	void readConfig(const TQString& profile);
	void saveConfig(const TQString& profile);

protected slots:
	void slotDeleteMailbox();
	void slotNewMailbox();
	void slotMailboxSelected(TQListViewItem *item);

	void protocolSelected(int protocol);
	void browse();
	void advanced();

	void enableFetchCommand(bool);
	void browseFetchCommand();

protected:
	const KBiffURL defaultMailbox() const;

private:
	TQDict<KBiffMailbox> *mailboxHash;
	TQListViewItem       *oldItem;

	unsigned int port;
	unsigned int timeout;
	bool         preauth;
	bool         keepalive;
	bool         async;
	bool         useApop;
	TQComboBox   *comboProtocol;
	TQLineEdit   *editMailbox;
	TQLineEdit   *editServer;
	TQLineEdit   *editUser;
	TQLineEdit   *editPassword;
	TQLineEdit   *editFetchCommand;
	TQCheckBox   *checkFetchCommand;
	TQCheckBox   *checkStorePassword;
	TQPushButton *buttonBrowse;
	TQListView   *mailboxes;

	TQPushButton *buttonBrowseFetchCommand;
};

class KBiffAboutTab : public TQWidget
{
	TQ_OBJECT
public:
	KBiffAboutTab(TQWidget *parent=0);
	virtual ~KBiffAboutTab();

protected slots:
	void mailTo(const TQString&);
	void homepage(const TQString&);
};

class KBiffNewDlg : public KDialog
{
	TQ_OBJECT
public:
	KBiffNewDlg(TQWidget* parent = 0, const char * name = 0);

	const TQString getName() const
		{ return editName->text(); }

private:
	TQLineEdit *editName;
};

#endif // SETUPDLG_H
