// This defines the interface to the TQextScintillaLexerJava class.
//
// Copyright (c) 2006
// 	Riverbank Computing Limited <info@riverbankcomputing.co.uk>
// 
// This file is part of TQScintilla.
// 
// This copy of TQScintilla is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// TQScintilla is supplied in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
// 
// You should have received a copy of the GNU General Public License along with
// TQScintilla; see the file LICENSE.  If not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


#ifndef TQEXTSCINTILLALEXERJAVA_H
#define TQEXTSCINTILLALEXERJAVA_H


#include <tqobject.h>

#include <tqextscintillaglobal.h>
#include <tqextscintillalexercpp.h>


//! \brief The TQextScintillaLexerJava class encapsulates the Scintilla Java
//! lexer.
class TQEXTSCINTILLA_EXPORT TQextScintillaLexerJava : public TQextScintillaLexerCPP
{
	TQ_OBJECT
  

public:
	//! Construct a TQextScintillaLexerJava with parent \a parent and name
	//! \a name.  \a parent is typically the TQextScintilla instance.
	TQextScintillaLexerJava(TQObject *parent = 0,const char *name = 0);

	//! Destroys the TQextScintillaLexerJava instance.
	virtual ~TQextScintillaLexerJava();

	//! Returns the name of the language.
	const char *language() const;

	//! Returns the set of keywords for the keyword set \a set recognised
	//! by the lexer as a space separated string.
	const char *keywords(int set) const;

private:
#if defined(TQ_DISABLE_COPY)
	TQextScintillaLexerJava(const TQextScintillaLexerJava &);
	TQextScintillaLexerJava &operator=(const TQextScintillaLexerJava &);
#endif
};

#endif
