/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_SIMPLEEVENTEDITDIALOG_H_
#define _RG_SIMPLEEVENTEDITDIALOG_H_

#include "base/Event.h"
#include <string>
#include <kdialogbase.h>


class TQWidget;
class TQString;
class TQSpinBox;
class TQPushButton;
class TQLineEdit;
class TQLabel;
class TQGroupBox;
class TQCheckBox;
class KComboBox;


namespace Rosegarden
{

class RosegardenGUIDoc;


class SimpleEventEditDialog : public KDialogBase
{
    TQ_OBJECT
  
public:
    SimpleEventEditDialog(TQWidget *parent,
                          RosegardenGUIDoc *doc,
                          const Event &event,
                          bool inserting = false); // inserting or editing

    bool isModified() const { return m_modified; }
    Event getEvent();

    // Setup the dialog for a new event type
    void setupForEvent();

public slots:
    void slotEventTypeChanged(int value);
    void slotAbsoluteTimeChanged(int value);
    void slotDurationChanged(int value);
    void slotNotationAbsoluteTimeChanged(int value);
    void slotNotationDurationChanged(int value);
    void slotPitchChanged(int value);
    void slotVelocityChanged(int value);
    void slotMetaChanged(const TQString &);
    void slotEditAbsoluteTime();
    void slotEditNotationAbsoluteTime();
    void slotEditDuration();
    void slotEditNotationDuration();
    void slotLockNotationChanged();
    void slotEditPitch();
    void slotSysexLoad();
    void slotSysexSave();

protected:
    Event        m_event;
    RosegardenGUIDoc        *m_doc;

    std::string              m_type;
    timeT        m_absoluteTime;
    timeT        m_notationAbsoluteTime;
    timeT        m_duration;
    timeT        m_notationDuration;

    KComboBox               *m_typeCombo;
    TQLabel                  *m_typeLabel;

    TQLabel                  *m_timeLabel;
    TQLabel                  *m_durationLabel;
    TQLabel                  *m_pitchLabel;
    TQLabel                  *m_velocityLabel;
    TQLabel                  *m_metaLabel;
    TQLabel                  *m_controllerLabel;
    TQLabel                  *m_controllerLabelValue;

    TQSpinBox                *m_timeSpinBox;
    TQSpinBox                *m_durationSpinBox;
    TQSpinBox                *m_pitchSpinBox;
    TQSpinBox                *m_velocitySpinBox;

    TQPushButton             *m_timeEditButton;
    TQPushButton             *m_durationEditButton;
    TQPushButton             *m_pitchEditButton;
    TQPushButton             *m_sysexLoadButton;
    TQPushButton             *m_sysexSaveButton;

    TQGroupBox               *m_notationGroupBox;
    TQLabel                  *m_notationTimeLabel;
    TQLabel                  *m_notationDurationLabel;
    TQSpinBox                *m_notationTimeSpinBox;
    TQSpinBox                *m_notationDurationSpinBox;
    TQPushButton             *m_notationTimeEditButton;
    TQPushButton             *m_notationDurationEditButton;
    TQCheckBox               *m_lockNotationValues;

    TQLineEdit               *m_metaEdit;

    bool                     m_modified;
};



}

#endif
