//
// C++ Implementation: filterlogviewmoveditem
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "filterlogviewmoveditem.h"

FilterLogViewMovedItem::FilterLogViewMovedItem( TDEListView * parent )
  : TDEListViewItem( parent )
{
}


FilterLogViewMovedItem::~FilterLogViewMovedItem()
{
}

void FilterLogViewMovedItem::setValues( TQDateTime date, TQString sender, TQString account, TQString mailbox, TQString subject )
{
  //store values
  this->date = date;
  this->sender = sender;
  this->account = account;
  this->mailbox = mailbox;
  this->subject = subject;

  //set column text
  setText( ColDate, date.toString( TQt::LocalDate ) );
  setText( ColSender, sender );
  setText( ColAccount, account );
  setText( ColMailbox, mailbox );
  setText( ColSubject, subject );
}

int FilterLogViewMovedItem::compare( TQListViewItem * i, int col, bool ascending ) const
{
  if( col == ColDate )
  {
    if( this->date < ((FilterLogViewMovedItem*)i)->getDate() ) return -1;
    if( this->date > ((FilterLogViewMovedItem*)i)->getDate() ) return 1;
    else return 0;
  }
  else
    return key( col, ascending ).compare( i->key( col, ascending) );

}

TQDateTime FilterLogViewMovedItem::getDate( )
{
  return date;
}

