/***************************************************************************
                          board_base.cpp  -  description
                             -------------------
    begin                : Fri Feb 28 2003
    copyright            : (C) 2003 by The Knights Team
    email                : knights-general@lists.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "board_base.moc"
#include "resource.h"
#include "logic.h"

board_base::board_base(TQWidget *parent, const char *name, resource *Rsrc, logic *Lgc ) : TQWidget(parent,name)
{
	/* Setup Variables */
	myResource = Rsrc;
	myLogic = Lgc;

	paused = false;
	flip = false;
	localArmy = WHITE;
}
board_base::~board_base()
{
}
///////////////////////////////////////
//
//	board_base::setPaused
//
///////////////////////////////////////
void board_base::setPaused( const bool &state )
{
	paused = state;
	redrawAll();
}
///////////////////////////////////////
//
//	board_base::setLocalArmy
//
///////////////////////////////////////
void board_base::setLocalArmy( const bool &state )
{
	if( state == localArmy )
		return;
	localArmy = state;
	redrawAll();
}
///////////////////////////////////////
//
//	board_base::flipBoard
//
///////////////////////////////////////
void board_base::flipBoard( void )
{
	flip = !flip;
	redrawAll();
}
///////////////////////////////////////
//
//	board_base::drawMove
//
///////////////////////////////////////
void board_base::drawMove( const ChessMove&, const bool& )
{
	/* Subclasses MUST reimplement this */
}
///////////////////////////////////////
//
//  board_base::resizeBoard
//
///////////////////////////////////////
void board_base::resizeBoard( void )
{
	/* Subclasses MUST reimplement this */
}
///////////////////////////////////////
//
//	board_base::redrawAll
//
///////////////////////////////////////
void board_base::redrawAll( void )
{
	/* Subclasses MUST reimplement this */
}
///////////////////////////////////////
//
//	board_base::drawPosition
//
///////////////////////////////////////
void board_base::drawPosition( const int& )
{
}
///////////////////////////////////////
//
//	board_base::setPremovePositions
//
///////////////////////////////////////
void board_base::setPremovePositions( const int&, const int& )
{
}
///////////////////////////////////////
//
//	board_base::commit
//
///////////////////////////////////////
void board_base::commit( void )
{
}
///////////////////////////////////////
//
//	board_base::redrawLights
//
///////////////////////////////////////
void board_base::redrawLights( void )
{
}
