/***************************************************************************
                          accel.cpp  -  description
                             -------------------
    begin                : Wed Nov 6 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "accel.moc"
#include <tdelocale.h>

Accel::Accel( TQWidget *parent, TQObject *target ) : TDEAccel( parent )
{
	insertItem( i18n("Previous Move"), "Previous Move", Key_Up, true );
	insertItem( i18n("Next Move"), "Next Move", Key_Down, true );
	insertItem( i18n("Enter Text"), "Enter Text", Key_Return, true );
	insertItem( i18n("Page Up"), "Page Up", Key_PageUp, true );
	insertItem( i18n("Page Down"), "Page Down", Key_PageDown, true );
	insertItem( i18n("Increase Board Size"), "Board Up", ALT + Key_Plus, true );
	insertItem( i18n("Decrease Board Size"), "Board Down", ALT + Key_Minus, true );
	insertItem( i18n("Last History Item"), "Last History Item", SHIFT + Key_Up, true );
	insertItem( i18n("Next History Item"), "Next History Item", SHIFT + Key_Down, true );
	insertItem( i18n("Reply to the Last Tell"), "Tell Reply", ALT + Key_R, true );
	insertItem( i18n("Reply to the Channel"), "Channel Reply", ALT + Key_C, true );
	insertItem( i18n("Kibitz"), "Kibitz", ALT + Key_K, true );
	insertItem( i18n("Whisper"), "Whisper", ALT + Key_W, true );
	readSettings();

	if( target )
		setTarget( target );
}
Accel::~Accel()
{
	writeSettings();
}
void Accel::setTarget( TQObject *target )
{
	connectItem( "Board Down" , target, TQ_SIGNAL( board_down() ) );
	connectItem( "Board Up" , target, TQ_SIGNAL( board_up() ) );
	connectItem( "Previous Move" , target, TQ_SIGNAL( move_prev() ) );
	connectItem( "Next Move" , target, TQ_SIGNAL( move_next() ) );
	connectItem( "Page Up", target, TQ_SIGNAL( page_up() ) );
	connectItem( "Page Down", target, TQ_SIGNAL( page_down() ) );
	connectItem( "Last History Item", target, TQ_SIGNAL( history_prev() ) );
	connectItem( "Next History Item", target, TQ_SIGNAL( history_next() ) );
	connectItem( "Tell Reply", target, TQ_SIGNAL( reply_tell() ) );
	connectItem( "Channel Reply", target, TQ_SIGNAL( reply_channel() ) );
	connectItem( "Enter Text", target, TQ_SIGNAL( focus() ) );
	connectItem( "Kibitz", target, TQ_SIGNAL( kibitz() ) );
	connectItem( "Whisper", target, TQ_SIGNAL( whisper() ) );
}
