/*
	appobserver.h - An application observer/killer
	Copyright (C) 2005  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __APPOBSERVER_H__
#define __APPOBSERVER_H__

#include <sys/types.h>

#include <tqhbox.h>

class TQComboBox;
class TQProcess;

class KPushButton;

/**
 * A process info.
 */
class Process
{
private:
	friend class AppObserver;
	pid_t pid; /**< A process ID. */
	TQString command; /**< A process command (e.g. "firefox"). */
	TQString user; /**< An owner of the process (e.g. "root"). */
};

/**
 * An application observer/killer (stupid name ;-).
 */
class AppObserver: public TQHBox
{
	TQ_OBJECT
public:
	/**
	 * Constructor.
	 * @param parent A parent widget
	 */
	AppObserver(TQWidget *parent);

	/**
	 * Returns textual information about the current state,
	 * or @c TQString::null.
	 */
	TQString getInfo() const;

	/**
	 * Returns @c true if selected process exists.
	 */
	bool isSelectedProcessRunning() const;

	/**
	 * Returns @c true if selected process exists;
	 * otherwise displays an error message.
	 */
	bool isValid() const;

	/**
	 * Refreshes the list of processes.
	 */
	void refresh();

	/**
	 * Enables/disables related widgets.
	 * @param yes @c true to enable widgets
	 */
	void setWidgetsEnabled(const bool yes) const;
private:
	KPushButton
		*b_kill,
		*b_refresh;
	TQComboBox *cb_processes;
	TQMap<int, Process> *_processesMap;
	TQProcess *_process;
	TQString _buf;
private slots:
	void slotKill();
	void slotProcessExit();
	void slotReadStdout();
	void slotRefresh();
};

#endif // __APPOBSERVER_H__
