/*
    Copyright (c) 2002-2003 Alexander Kellett <lypanov@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License (LGPL) as published by the Free Software Foundation;
    either version 2 of the License, or (at your option) any later
    version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __CRASHES_PLUGIN_H
#define __CRASHES_PLUGIN_H

#include <tqmap.h>
#include <tqvaluelist.h>
#include <tqstringlist.h>

#include <kurl.h>
#include <klibloader.h>
#include <tdeparts/plugin.h>

class TDEHTMLPart;
class TDEActionMenu;

class CrashesPlugin : public KParts::Plugin
{
  TQ_OBJECT
  

public:
  CrashesPlugin( TQObject* parent, const char* name,
                   const TQStringList & );
  ~CrashesPlugin();

protected slots:
  void slotAboutToShow();
  void slotClearCrashes();
  void slotItemSelected(int);
  void slotGroupSelected(int);
  void newBookmarkCallback( const TQString &, const TQCString &, const TQString & );
  void endFolderCallback( );

private:
  int m_selectedItem;

  TDEHTMLPart* m_part;
  TDEActionMenu* m_pCrashesMenu;

  typedef TQPair<TQString,TQCString> Crash;
  typedef TQValueList<Crash> CrashesList;

  CrashesList m_crashesList;

  typedef TQPair<int, int> CrashRange;
  typedef TQValueList<CrashRange> CrashRangesList;

  CrashRangesList m_crashRangesList;

};

#endif
