#################################################
#
#  (C) 2013 Alexander Golubev 
#  fatzer2 (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

# required stuff

tde_setup_architecture_flags( )

include(CheckCXXSymbolExists)
include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )

find_package( TQt )
find_package( TDE )


##### check for gcc visibility support #########

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( )


##### kicker-applets ############################

if( BUILD_KICKER_APPLETS )
  check_include_file( "fcntl.h" HAVE_FCNTL_H )

  if( WITH_XMMS )
    check_library_exists( xmms xmms_remote_is_running "" HAVE_XMMS_LIB )
    tde_save_and_set( CMAKE_REQUIRED_LIBRARIES  "xmms" )
    check_symbol_exists( xmms_remote_is_running "xmms/xmmsctrl.h" HAVE_XMMS )
    tde_restore( CMAKE_REQUIRED_LIBRARIES )
    if( HAVE_XMMS_LIB AND HAVE_XMMS )
      set( XMMS_LIBRARIES xmms )
    else( HAVE_XMMS )
      tde_message_fatal( "xmms is required, but was not found on your system" )
    endif( HAVE_XMMS )
  endif( WITH_XMMS )
endif( BUILD_KICKER_APPLETS )



##### other dependencies ########################

if( BUILD_KONQ_PLUGINS OR BUILD_NOATUN_PLUGINS )
  # arts
  if( WITH_ARTS )
    pkg_search_module( ARTS arts )
    if( NOT ARTS_FOUND )
      tde_message_fatal( "aRts is requested, but was not found on your system" )
    endif( )
  endif( WITH_ARTS )
endif( BUILD_KONQ_PLUGINS OR BUILD_NOATUN_PLUGINS )


if( BUILD_NOATUN_PLUGINS )
  # sdl
  if( WITH_SDL )
    pkg_search_module( SDL sdl )
    if( NOT SDL_FOUND )
      check_include_file( SDL/SDL.h HAVE_SDL_H )
      if( NOT HAVE_SDL_H )
        tde_message_fatal( "SDL is requested, but was not found on your system" )
      endif ( )
      set ( SDL_INCLUDE_DIRS /usr/include/SDL )
      set ( SDL_LIBRARIES SDL ${CMAKE_THREAD_LIBS_INIT} )
    endif( )
  endif( WITH_SDL )

  # berkeley db
  if( WITH_BERKELEY_DB )
    find_path( BERKELEY_DB_INCLUDE_DIRS db_cxx.h )
    find_library( BERKELEY_DB_LIBS db_cxx )
    if( BERKELEY_DB_INCLUDE_DIRS STREQUAL BERKELEY_DB_INCLUDE_DIRS-NOTFOUND OR BERKELEY_DB_LIBS STREQUAL BERKELEY_DB_LIBS-NOTFOUND )
      tde_message_fatal( "BerkeleyDB is requested, but was not found on your system" )
    endif( )
  endif( WITH_BERKELEY_DB )
endif( BUILD_NOATUN_PLUGINS )


if( BUILD_TDEFILE_PLUGINS AND WITH_SSL )
  # FIXME: There should be a better way to check for SSL support in tdelibs, but at the time of
  #        writing tdelibs doesn't seam to provide one. <2025-08-11 Fat-Zer>
  tde_save_and_set( CMAKE_REQUIRED_INCLUDES ${TDE_INCLUDE_DIR} )
  check_cxx_symbol_exists( "KSSL_HAVE_SSL" "ksslconfig.h" KSSL_HAVE_SSL )
  tde_restore( CMAKE_REQUIRED_INCLUDES )

  if( NOT KSSL_HAVE_SSL )
    tde_message_fatal( "SSL is requested, but tdelibs on your system was build without SSL support" )
  endif( )
endif( )
