/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef MULTILINEEDITORIMPL_H
#define MULTILINEEDITORIMPL_H

#include <tqaction.h>
#include <tqtextedit.h>
#include <tqrichtext_p.h>
#include "multilineeditor.h"

class FormWindow;
class TQToolBar;
class TQTextDocument;

class TextEdit : public TQTextEdit
{
    TQ_OBJECT
  

public:
    TextEdit( TQWidget *parent = 0, const char *name = 0 );
    TQTextDocument *document() const { return TQTextEdit::document(); }
    TQTextParagraph *paragraph();

};

class ToolBarItem : public TQAction
{
    TQ_OBJECT
  

public:
    ToolBarItem( TQWidget *parent, TQWidget *toolBar,
                 const TQString &label, const TQString &tagstr,
		 const TQIconSet &icon, const TQKeySequence &key = 0 );
    ~ToolBarItem();
signals:
    void clicked( const TQString &t );

protected slots:
    void wasActivated();
private:
    TQString tag;
};


class MultiLineEditor : public MultiLineEditorBase
{
    TQ_OBJECT
  

public:
    MultiLineEditor( bool call_static, bool richtextMode, TQWidget *parent, TQWidget *editWidget,
		     FormWindow *fw, const TQString &text = TQString() );
    bool useWrapping() const;
    void setUseWrapping( bool );
    static TQString getText( TQWidget *parent, const TQString &text, bool richtextMode, bool *useWrap );
    int exec();

protected slots:
    void okClicked();
    void applyClicked();
    void cancelClicked();
    void insertTags( const TQString& );
    void insertBR();
    void showFontDialog();
    void changeWrapMode( bool );

    void closeEvent( TQCloseEvent *e );

private:
    TQString getStaticText();
    TextEdit *textEdit;
    TQTextEdit *mlined;
    FormWindow *formwindow;
    TQToolBar *basicToolBar;
    TQToolBar *fontToolBar;
    TQToolBar *optionsToolBar;
    TQAction *wrapAction;
    int res;
    TQString staticText;
    bool callStatic;
    bool oldDoWrap, doWrap;
    TQVariant oldWrapMode;
    TQString oldWrapString;
};

#endif
