/****************************************************************************
** $Id$
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

import org.trinitydesktop.qt.*;
import java.util.Date;

class AnalogClock extends TQWidget		// analog clock widget
{

private Date	time;

//
// Constructs an analog clock widget that uses an internal TQTimer.
//

public AnalogClock( TQWidget parent )
{
	this(parent, null);
}

public AnalogClock( TQWidget parent, String name )
{
	super( parent, name );
    time = new Date();		// get current time
    TQTimer internalTimer = new TQTimer( this );	// create internal timer
    connect( internalTimer, TQ_SIGNAL("timeout()"), TQ_SLOT("timeout()") );
    internalTimer.start( 5000 );		// emit signal every 5 seconds
}


public void setTime( Date t )
{
    time = t;
    timeout();
}

//
// The TQTimer.timeout() signal is received by this slot.
//

public void timeout()
{
    Date old_time = new Date();	// get the current time
	old_time.setTime( time.getTime() - 5000 );
	time.setTime( time.getTime() + 5000 );
    if ( old_time.getMinutes() != time.getMinutes() ) {	// minute has changed
	if (autoMask())
	    updateMask();
	else
	    update();
    }
}


public void paintEvent( TQPaintEvent event )
{
    if ( autoMask() )
	return;
    TQPainter paint = new TQPainter( this );
    paint.setBrush( colorGroup().foreground() );
    drawClock( paint );
}

// If the clock is transparent, we use updateMask()
// instead of paintEvent()

public void updateMask()	// paint clock mask
{
    TQBitmap bm = new TQBitmap( size() );
    bm.fill( color0() );			//transparent

    TQPainter paint = new TQPainter();
    paint.begin( bm, this );
    paint.setBrush( color1() );		// use non-transparent color
    paint.setPen( color1() );

    drawClock( paint );

    paint.end();
    setMask( bm );
}

//
// The clock is painted using a 1000x1000 square coordinate system, in
// the a centered square, as big as possible.  The painter's pen and
// brush colors are used.
//
public void drawClock( TQPainter paint )
{
    paint.save();
    
    paint.setWindow( -500,-500, 1000,1000 );

    TQRect v = paint.viewport();
    int d = v.width() < v.height() ? v.width() : v.height();
    paint.setViewport( v.left() + (v.width()-d)/2,
			v.top() + (v.height()-d)/2, d, d );

    // time = TQTime.currentTime();
    TQPointArray pts = new TQPointArray();

    paint.save();
    paint.rotate( 30*(time.getHours()%12-3) + time.getMinutes()/2 );
    pts.setPoints( 4, new short[] { -20,0,  0,-20, 300,0, 0,20 } );
    paint.drawConvexPolygon( pts );
    paint.restore();

    paint.save();
    paint.rotate( (time.getMinutes()-15)*6 );
    pts.setPoints( 4, new short[] { -10,0, 0,-10, 400,0, 0,10 } );
    paint.drawConvexPolygon( pts );
    paint.restore();

    for ( int i=0; i<12; i++ ) {
	paint.drawLine( 440,0, 460,0 );
	paint.rotate( 30 );
    }

    paint.restore();
}


public void setAutoMask(boolean b)
{
    if (b)
	setBackgroundMode( PaletteForeground );
    else
	setBackgroundMode( PaletteBackground );
    super.setAutoMask(b);
}

public static void main( String[] args )
{
    TQApplication a = new TQApplication( args );
    AnalogClock clock = new AnalogClock(null, null);
    if ( args.length == 1 && args[0].equals("-transparent") )
        clock.setAutoMask( true );
    clock.resize( 100, 100 );
    a.setMainWidget( clock );
    clock.setCaption("Qt Example - Analog Clock");
    clock.show();
    int result = a.exec();
    return;
}

static {
	qtjava.initialize();
}

}

