/*
    msnsecureloginhandler.h - SSL login for MSN protocol

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    Kopete    (c) 2002-2005 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#ifndef MSNSECURELOGINHANDLER_H
#define MSNSECURELOGINHANDLER_H

#include <tqobject.h>

namespace TDEIO
{
	class Job;
	class MetaData;
}

/**
 * This class handle the login process. It connect to the .NET Password service and retrive the ticket(tweener) to login.
 * Use TDEIO.
 *
 * @author Michaël Larouche <michael.larouche@kdemail.net>
*/
class MSNSecureLoginHandler : public TQObject
{
TQ_OBJECT
  
public:
    MSNSecureLoginHandler(const TQString &accountId, const TQString &password, const TQString &authParameters);

    ~MSNSecureLoginHandler();

	void login();

signals:
	/**
	 * TODO: return to const TQString &
	 */
	void loginSuccesful(TQString ticket);
	void loginBadPassword();
	void loginFailed();

private slots:
	void slotLoginServerReceived(TDEIO::Job *);
	/**
	 * We have received our ticket to login.
	 */
	void slotTweenerReceived(TDEIO::Job *);

private:
	/**
	 * Store the password.
	 */
	TQString m_password;
	/**
	 * Store the accountId.
	 */
	TQString m_accountId;
	/**
	 * Store the authentification parameters
	 */
	TQString m_authentification;

	void displayMetaData(TDEIO::MetaData data);
};

#endif
