/*
    meanwhilecontact.h - a contact

    Copyright (c) 2003-2004 by Sivaram Gottimukkala  <suppandi@gmail.com>

    Kopete    (c) 2002-2004 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#ifndef MEANWHILECONTACT_H
#define MEANWHILECONTACT_H

#include <tqmap.h>
#include "kopetecontact.h"
#include "kopetemessage.h"
#include "meanwhileaccount.h"

class TDEAction;
class TDEActionCollection;
namespace Kopete { class Account; }
namespace Kopete { class ChatSession; }
namespace Kopete { class MetaContact; }

class MeanwhileContact : public Kopete::Contact
{
    TQ_OBJECT
  
public:

    MeanwhileContact(TQString userId, TQString nickname,
            MeanwhileAccount *account, Kopete::MetaContact *parent);
    ~MeanwhileContact();

    virtual bool isReachable();

    virtual void serialize(TQMap<TQString, TQString> &serializedData,
            TQMap<TQString, TQString> &addressBookData);

    virtual Kopete::ChatSession *manager(
            CanCreateFlags canCreate = CanCreate);

    TQString meanwhileId() const;

        virtual void sync(unsigned int changed = 0xff);

public slots:

    void sendMessage( Kopete::Message &message );
    void receivedMessage( const TQString &message );
    virtual void slotUserInfo();

protected slots:
    void showContactSettings();
    void slotChatSessionDestroyed();
    void slotSendTyping(bool isTyping);
	
private:
    TQString m_meanwhileId;
    Kopete::ChatSession *m_msgManager;
};

#endif
