/*
 *  Copyright (c) 2002-2003 Jesper K. Pedersen <blackie@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/
#ifdef TQT_ONLY
  #include "compat.h"
#else
  #include <tdemessagebox.h>
  #include <kpushbutton.h>
  #include <kstdguiitem.h>
  #include "tdemultiformlistbox-windowed.moc"
#endif

#include "widgetwindow.h"
#include "windowlistboxitem.h"

KMultiFormListBoxWindowed::KMultiFormListBoxWindowed(KMultiFormListBoxFactory *factory, TQWidget *parent,
																	 bool showUpDownButtons, bool showHelpButton,
																	 TQString addButtonText,const char *name)
  : TQWidget( parent, name )
{
  _layout = new TQVBoxLayout(this);

	TQHBoxLayout *innerLayout = new TQHBoxLayout();
	_layout->addLayout(innerLayout);

  _listbox = new TDEListBox(this,"listbox");
  _listbox->setSelectionMode(TQListBox::Single);
  innerLayout->addWidget(_listbox);

  TQVBoxLayout *buttons = new TQVBoxLayout();
  innerLayout->addLayout(buttons);

  TQPushButton *but = new TQPushButton(addButtonText, this,"Add Button");
  buttons->addWidget(but,0);
  connect(but, TQ_SIGNAL(clicked()), this, TQ_SLOT(addNewElement()));

  but = new TQPushButton(i18n("Edit"), this,"Edit Button");
  buttons->addWidget(but,0);
  connect(but,TQ_SIGNAL(clicked()), this, TQ_SLOT(slotEditSelected()));
  connect(_listbox, TQ_SIGNAL(doubleClicked(TQListBoxItem *)), this, TQ_SLOT(slotEditSelected(TQListBoxItem *)));
	_buttonList.append(but);

  but = new TQPushButton(i18n("Delete"), this, "Delete Button");
  buttons->addWidget(but,0);
  connect(but, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotDeleteEntry()));
	_buttonList.append(but);

  but = new TQPushButton(i18n("Copy"), this, "Copy Button");
  buttons->addWidget(but,0);
  connect(but, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotCopySelected()));
	_buttonList.append(but);

	if (showUpDownButtons) {
		but = new TQPushButton(i18n("Up"), this, "Up Button");
		buttons->addWidget(but, 0);
		connect(but, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotMoveItemUp()));
		_buttonList.append(but);

		but = new TQPushButton(i18n("Down"), this, "Down Button");
		buttons->addWidget(but, 0);
		connect(but, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotMoveItemDown()));
		_buttonList.append(but);
	}

	if (showHelpButton) {
		but = new KPushButton(KStdGuiItem::help(), this, "Help Button");
		buttons->addWidget(but, 0);
		connect(but, TQ_SIGNAL(clicked()), this, TQ_SIGNAL(showHelp()));
	}

  buttons->addStretch(1);
  _factory = factory;
	slotUpdateButtonState();

}

KMultiFormListBoxEntryList KMultiFormListBoxWindowed::elements()
{
  KMultiFormListBoxEntryList list;
  for (unsigned int i=0; i < _listbox->count(); i++) {
    WindowListboxItem *item = (WindowListboxItem *) _listbox->item(i);
    list.append(item->entry());
  }
  return list;
}

void KMultiFormListBoxWindowed::delElement(TQWidget */*elm*/)
{
    // kdDebug() << "KMultiFormListBoxWindowed::delElement NOT YET IMPLEMENTED"<<endl;
	// TODO
}

void KMultiFormListBoxWindowed::delAnElement()
{
    // kdDebug() << "KMultiFormListBoxWindowed::delAnElement NOT YET IMPLEMENTED"<<endl;
  // TODO
}


void KMultiFormListBoxWindowed::append(KMultiFormListBoxEntry *elm)
{
  (void) new WidgetWindow(_factory, elm, _listbox);
	slotUpdateButtonState();
}

void KMultiFormListBoxWindowed::addNewElement()
{
	// kdDebug() << "addNewElement " << _factory << "," << _listbox << endl;

  TQWidget *widget = new WidgetWindow(_factory, _listbox);
	widget->show();
	connect(widget, TQ_SIGNAL(finished()), this, TQ_SLOT(slotUpdateButtonState()));
}

void KMultiFormListBoxWindowed::addElement()
{
  new WidgetWindow(_factory, _listbox);
	slotUpdateButtonState();
}

void KMultiFormListBoxWindowed::slotEditSelected(TQListBoxItem *item)
{
  ((WindowListboxItem *) item)->displayWidget();
}

void KMultiFormListBoxWindowed::slotEditSelected()
{
  WindowListboxItem *item = selected();
  if (item) {
    slotEditSelected(item);
  }
}

void KMultiFormListBoxWindowed::slotDeleteEntry()
{
  WindowListboxItem *item = selected();
  if (item) {
		int answer =
			KMessageBox::warningContinueCancel(0, i18n("Delete item \"%1\"?").arg(item->text()),i18n("Delete Item"),KStdGuiItem::del());
		if (answer == KMessageBox::Continue) {
			delete item;
			slotUpdateButtonState();
		}
  }
}

void KMultiFormListBoxWindowed::slotCopySelected()
{
  WindowListboxItem *item = selected();
  if (item) {
    item->clone();
  }
}

WindowListboxItem *KMultiFormListBoxWindowed::selected()
{
  int i = _listbox->currentItem();
  if (i == -1) {
    return 0;
  } else {
    return (WindowListboxItem *) _listbox->item(i);
  }
}

void KMultiFormListBoxWindowed::slotMoveItemUp()
{
	WindowListboxItem *item = selected();
	if (item == 0)
		return;

	int index = _listbox->index(item);
	if (index != 0) {
		_listbox->takeItem(item);
		_listbox->insertItem(item, index-1);
		_listbox->setCurrentItem(item);
	}
}

void KMultiFormListBoxWindowed::slotMoveItemDown()
{
	WindowListboxItem *item = selected();
	if (item == 0)
		return;

	unsigned int index = _listbox->index(item);
	if (index < _listbox->count()) {
		_listbox->takeItem(item);
		_listbox->insertItem(item, index+1);
		_listbox->setCurrentItem(item);
	}
}

void KMultiFormListBoxWindowed::slotUpdateButtonState()
{
	bool on = (_listbox->count() != 0);
	for (unsigned int i=0; i<_buttonList.count(); i++) {
		_buttonList.at(i)->setEnabled(on);
	}
}
