/***************************************************************************
 *   Copyright (C) 2005 by Joe Ferris                                      *
 *   jferris@optimistictech.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef CACHEDCATALOG_H
#define CACHEDCATALOG_H

#include <tqptrlist.h>

#include "katapultcatalog.h"

class Match;
class KatapultItem;

/**
@author Joe Ferris
*/
class TDE_EXPORT CachedCatalog : public KatapultCatalog
{
	TQ_OBJECT
  
public:
	CachedCatalog();
	virtual ~CachedCatalog();
	
	const KatapultItem * findExact(TQString text) const;

protected:
	virtual void queryChanged();
	virtual unsigned int minQueryLen() const;
	
	void addItem(KatapultItem *);
	
private:
	Match queryItem(const KatapultItem *, TQString) const;

	TQPtrList<KatapultItem> cache, results;

};

#endif
