/***************************************************************************
                          knutnewupsdlg.cpp  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutnewupsdlg.h"
 
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdeactionselector.h>

#include <tqstring.h>
#include <tqlayout.h>
#include <tqframe.h>
#include <tqlabel.h>
#include <tqgroupbox.h>
//#include <tqradiobutton.h>
#include <tqbuttongroup.h>
#include <tqcheckbox.h>
#include <tqlistbox.h>

//#include <iostream>



KNutNewUpsDlg::KNutNewUpsDlg (KNutUpsData* const upsData, KNutVarData* const analogData, const bool add, TQWidget* parent, const char* name, const bool modal)
  : KDialogBase(Plain, i18n("New Ups"),Help|Ok|Cancel,Ok, parent, name, modal, true ), addMember(add), m_myUpsData(upsData) {

  setName( "KupsNewUpsDlg" );

  TQFrame *page =plainPage();
  TQVBoxLayout *mainLayout = new TQVBoxLayout( page, 0, spacingHint(), "mainLayout" );
    TQHBoxLayout *dataLayout = new TQHBoxLayout(mainLayout, spacingHint(),"dataLayout");


        TQGroupBox *hostBox = new TQGroupBox (page,"hostBox");
        TQGridLayout *hostLayout = new TQGridLayout (hostBox, 5, 2, spacingHint () );
        hostBox->setFrameStyle(TQFrame::NoFrame);
        dataLayout->addWidget(hostBox);

          TQHBoxLayout *portLayout = new TQHBoxLayout(-1,"portLayout");
          hostLayout->addLayout(portLayout,4,1);

          TQHBoxLayout *loginLayout = new TQHBoxLayout(-1,"loginLayout");
          hostLayout->addLayout(loginLayout,5,1);


    TQGroupBox* GroupBox2 = new TQGroupBox( page, "GroupBox2" );


      TQVBoxLayout *vActionSelectorLayout = new TQVBoxLayout( GroupBox2, 0, spacingHint(), "VActionLayout" );
      vActionSelectorLayout->addSpacing(fontMetrics().lineSpacing());
      TQHBoxLayout *hActionSelectorLayout = new TQHBoxLayout( vActionSelectorLayout, spacingHint(), "HActionLayout" );
      vActionSelectorLayout->addSpacing(10);


  TQLabel* TextLabel1 = new TQLabel( i18n("Name")+":",hostBox, "TextLabel1" );
  hostLayout->addWidget (TextLabel1,1,0);
  m_lineEdit1 = new KLineEdit( hostBox, "LineEdit1" );
  m_lineEdit1->setEnabled( add ); 
  // pokud se nejedna o pridani (add) neni jmeno aktivovani
  // when makes adding name isn;t activated
  hostLayout->addWidget (m_lineEdit1,1,1);

  TQLabel* TextLabel2 = new TQLabel(i18n("UPS address")+":", hostBox, "TextLabel2" );
  hostLayout->addWidget (TextLabel2,2,0);
  m_lineEdit2 = new KLineEdit( hostBox, "LineEdit2" );
  hostLayout->addWidget (m_lineEdit2,2,1);

// Name of UPS
  TQLabel* TextLabel7 = new TQLabel(i18n("UPS name")+":", hostBox, "TextLabel7" );
  hostLayout->addWidget (TextLabel7,3,0);
  m_lineEdit7 = new KLineEdit( hostBox, "LineEdit7" );
  hostLayout->addWidget (m_lineEdit7,3,1);


  TQLabel* TextLabel3 = new TQLabel(i18n("Delay (ms):"), hostBox, "TextLabel3" );
  hostLayout->addWidget (TextLabel3,4,0);
  m_lineEdit3 = new KLineEdit( hostBox, "LineEdit3" );
  m_lineEdit3->setText("5000");
  portLayout->addWidget(m_lineEdit3);
  portLayout->addSpacing(10);

  TQLabel* TextLabel4 = new TQLabel(i18n("Port:"), hostBox, "TextLabel4" );
  m_lineEdit4 = new KLineEdit( hostBox, "LineEdit4" );
  m_lineEdit4->setText(TQString("%1").arg(knc::DefaultPort));
  portLayout->addWidget(TextLabel4);
  portLayout->addWidget(m_lineEdit4);

  TQLabel* TextLabel5 = new TQLabel(i18n("User name:"), hostBox, "TextLabel5" );
  hostLayout->addWidget (TextLabel5,5,0);
  m_lineEdit5 = new KLineEdit( hostBox, "LineEdit5" );
  m_lineEdit5->setText("");
  loginLayout->addWidget(m_lineEdit5);
  loginLayout->addSpacing(10);

  TQLabel* TextLabel6 = new TQLabel(i18n("Password:"), hostBox, "TextLabel6" );
  m_lineEdit6 = new KLineEdit( hostBox, "LineEdit6" );
  m_lineEdit6->setEchoMode(TQLineEdit::Password);
  m_lineEdit6->setText("");
  loginLayout->addWidget(TextLabel6);
  loginLayout->addWidget(m_lineEdit6);

  m_savePassword = new TQCheckBox (i18n("Store NUT password in configuration file"),page,"savePassword");
  mainLayout->addWidget(m_savePassword);
  mainLayout->addWidget(GroupBox2);


  m_upsValueSelector = new TDEActionSelector(GroupBox2);

  m_upsValueSelector->setAvailableLabel(i18n("Availabled UPS values"));
  m_upsValueSelector->setSelectedLabel(i18n("Selected UPS values"));
  m_upsValueSelector->setAvailableInsertionPolicy(TDEActionSelector::Sorted);
  m_upsValueSelector->setSelectedInsertionPolicy(TDEActionSelector::AtBottom);

  m_upsValueSelector->availableListBox()->setSelectionMode(TQListBox::Multi);
  m_upsValueSelector->selectedListBox()->setSelectionMode(TQListBox::Multi);

  hActionSelectorLayout->addSpacing(10);
  hActionSelectorLayout->addWidget(m_upsValueSelector);
  hActionSelectorLayout->addSpacing(10);

  mainLayout->addStretch(10);

  GroupBox2->setTitle( i18n( "UPS Variables" ));

  TQListBox* aListBox = m_upsValueSelector->availableListBox();
  for (int i=1; i < knc::NumberOfTypes; i++) {  //values 0 is None, this values isn't showing
    new KNutUpsBoxItem (aListBox,analogData->getNameAnalogData(i),i);
    }

  aListBox->sort(true);
  }



KNutNewUpsDlg::~KNutNewUpsDlg() {
  }


void KNutNewUpsDlg::moveToSelectedList (const int codeUpsVar) {

if (codeUpsVar == 0) return;
if (isExistSelectedItem(codeUpsVar)) return;  //Value is moved yet

KNutUpsBoxItem * availableItem;
availableItem =(KNutUpsBoxItem*) m_upsValueSelector->availableListBox()->firstItem();

while (availableItem != 0) {
  if (availableItem->getVarCode() == codeUpsVar) {
    break;
    }
  availableItem=(KNutUpsBoxItem*)availableItem->next();
  }

//remove item from left list
if (availableItem != 0) {
   TQListBox* sListBox = m_upsValueSelector->selectedListBox();
   new KNutUpsBoxItem (sListBox,availableItem->text(),codeUpsVar);
   m_upsValueSelector->availableListBox()->removeItem(m_upsValueSelector->availableListBox()->index(availableItem));

  }
}


bool KNutNewUpsDlg::isExistSelectedItem (const int codeUpsVar) const {

KNutUpsBoxItem * selectedItem;
selectedItem =(KNutUpsBoxItem*) m_upsValueSelector->selectedListBox()->firstItem();


while (selectedItem != 0) {
  if (selectedItem->getVarCode() == codeUpsVar) return true;
  selectedItem=(KNutUpsBoxItem*)selectedItem->next();
  }
return false;
}


void KNutNewUpsDlg::putData (const KNutUpsData::upsRecordDef upsRecord ) {
  m_lineEdit1->setText(upsRecord.name);
  m_lineEdit2->setText(upsRecord.upsAddress);
  m_lineEdit7->setText(upsRecord.upsName);
  TQString delay, port;
  delay.setNum(upsRecord.delay);
  m_lineEdit3->setText(delay);
  port.setNum(upsRecord.port);
  m_lineEdit4->setText(port);
  m_lineEdit5->setText(upsRecord.userName);
  m_lineEdit6->setText(upsRecord.password);
//  RadioButton1->setChecked( !upsInfo.tcp );
//  RadioButton2->setChecked( upsInfo.tcp );
  m_savePassword->setChecked(m_savePassword);

  for (int j=0; j <knc::NumberOfVars; j++) moveToSelectedList (upsRecord.upsVarCode[j]);

  }


KNutUpsData::upsRecordDef KNutNewUpsDlg::getData (void ) const {
KNutUpsData::upsRecordDef upsRecord;

  upsRecord.name=m_lineEdit1->text();
  upsRecord.upsAddress=m_lineEdit2->text();
  upsRecord.upsName= m_lineEdit7->text();
  upsRecord.delay=m_lineEdit3->text().toLong();
  upsRecord.port=(short unsigned)m_lineEdit4->text().toUInt();
//  upsInfo.tcp=RadioButton2->isChecked();
  upsRecord.userName=m_lineEdit5->text();
  upsRecord.password=m_lineEdit6->text();
  upsRecord.savePassword=m_savePassword->isChecked();


  int j =0;
  KNutUpsBoxItem * selectedItem;
  selectedItem =(KNutUpsBoxItem*) m_upsValueSelector->selectedListBox()->firstItem();

  while (selectedItem != 0) {
    upsRecord.upsVarCode[j++]=selectedItem->getVarCode();
    selectedItem=(KNutUpsBoxItem*)selectedItem->next();
    }

  for (int i=j; i < knc::NumberOfVars; i++) { 
     upsRecord.upsVarCode[i]=0;
    }

  return upsRecord;
 }

/*********************************************************************************************/
/*                                                                                           */
/*                         PRIVATE SLOTS                                                     */
/*                                                                                           */
/*********************************************************************************************/
 
 

void KNutNewUpsDlg::slotOk() {
  bool ok;
  // closes window
  m_lineEdit1->setText(m_lineEdit1->text().stripWhiteSpace());
  m_lineEdit2->setText(m_lineEdit2->text().stripWhiteSpace());

  if ((m_lineEdit1->text().length() <1 )
  || (m_lineEdit2->text().length() <1 )) {
    KMessageBox::sorry (0,i18n("No Name or UPS address"));
    return;
    }

  if (addMember) {
    // when UpsName is existed we cannot make new record
    // pokud UpsName jiz existuje nemuzeme vytvorit novy zaznam
    if ( m_myUpsData->findName(m_lineEdit1->text()) != 0L ) {
    KMessageBox::sorry (0,i18n("This Name exist"));
    return;
    }
  }

  long delay = m_lineEdit3->text().toLong(&ok);
  if (! ok) {
    KMessageBox::sorry (0,i18n("Delay must be number"));
    return;
    }

  long port = m_lineEdit4->text().toLong(&ok);
  if (! ok) {
    KMessageBox::sorry (0,i18n("Port must be number"));
    return;
    }

  if ((port < knc::StartPort) || (port > knc::StopPort)) {
    KMessageBox::sorry (0,i18n("Port must be from 1025 until 65535"));
    return;
    }

  if (delay < knc::MinDelay) {
    KMessageBox::sorry (0,i18n("Delay is too small"));
    return;
    }
  accept ();
  }



#include "knutnewupsdlg.moc"
