/*
   KDChart - a multi-platform charting engine
   */

/****************************************************************************
 ** Copyright (C) 2001-2003 Klarälvdalens Datakonsult AB.  All rights reserved.
 **
 ** This file is part of the KDChart library.
 **
 ** This file may be distributed and/or modified under the terms of the
 ** GNU General Public License version 2 as published by the Free Software
 ** Foundation and appearing in the file LICENSE.GPL included in the
 ** packaging of this file.
 **
 ** Licensees holding valid commercial KDChart licenses may use this file in
 ** accordance with the KDChart Commercial License Agreement provided with
 ** the Software.
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ** See http://www.klaralvdalens-datakonsult.se/?page=products for
 **   information about KDChart Commercial License Agreements.
 **
 ** Contact info@klaralvdalens-datakonsult.se if any conditions of this
 ** licensing are not clear to you.
 **
 **********************************************************************/
#ifndef __KDCHARTTEXTPIECE_H__
#define __KDCHARTTEXTPIECE_H__

#include <tqstring.h>
#include <tqfont.h>
#include <tqregion.h>
#include <tqpalette.h>
#include <tqobject.h>
#include <kdchart_export.h>

class TQBrush;
class TQPainter;
class TQSimpleRichText;
class TQFontMetrics;

class KDCHART_EXPORT KDChartTextPiece :public TQObject
{
    TQ_OBJECT
  

    public:
        KDChartTextPiece();
        KDChartTextPiece( const TQString& text, const TQFont& font );
        KDChartTextPiece( TQPainter* painter, const TQString& text, const TQFont& font );
        virtual ~KDChartTextPiece();
        /**
          Copy the settings of text piece \c source into this box.

          \note Use this method instead of using the assignment operator.

          \sa clone
          */
        void deepCopy( const KDChartTextPiece* source );


        /**
          Create a new text piece on the heap, copy the settings stored by
          this text piece into the newly created text piece and return
          the pointer to the new text piece.

          \note Use this method instead of using the copy constructor.

          \sa deepCopy
          */
        const KDChartTextPiece* clone() const;

    private:
        KDChartTextPiece( const KDChartTextPiece& ) : TQObject(0) {}

    public slots:
        virtual int width() const;
        virtual int height() const;
        virtual int fontLeading() const;
        virtual TQRect rect( TQPainter *p, const TQRect& clipRect) const;
        virtual void draw( TQPainter *p, int x, int y, const TQRect& clipRect,
                const TQColor& color, const TQBrush* paper = 0 ) const;
        virtual void draw( TQPainter *p, int x, int y, const TQRegion& clipRegion,
                const TQColor& color, const TQBrush* paper = 0 ) const;

        TQString text() const;
        TQFont font() const;
        bool isRichText() const;
        

    protected:
        bool _isRichText;
        TQSimpleRichText* _richText; // used when _isRichText == true
        TQString _text; // used when _isRichText == false
        TQFont _font; // used when _isRichText == false
        TQFontMetrics* _metrics;
        bool _dirtyMetrics;
};

#endif
