/***************************************************************************
                          kgncpricesourcedlg.cpp
                             -------------------
    copyright            : (C) 2005 by Ace Jones
    author               : Tony Bloomfield
    email                : tonybloom@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// ----------------------------------------------------------------------------
// TQt Includes
#include <tqlabel.h>
#include <tqlistbox.h>
#include <tqlineedit.h>
#include <tqbuttongroup.h>
#include <tqlayout.h>
#include <tqapplication.h>

// ----------------------------------------------------------------------------
// TDE Includes
#include <tdeapplication.h>
#include <kurlrequester.h>
#include <ktextbrowser.h>
#include <tdelocale.h>

// ----------------------------------------------------------------------------
// Project Includes
#include "kgncpricesourcedlg.h"
#include "../converter/webpricequote.h"

KGncPriceSourceDlg::KGncPriceSourceDlg(TQWidget *parent, const char *name)
 : KGncPriceSourceDlgDecl(parent, name)
{
}
KGncPriceSourceDlg::KGncPriceSourceDlg(const TQString &stockName, const TQString &gncSource){
  // signals and slots connections
  connect( buttonGroup5, TQ_SIGNAL( released(int) ), this, TQ_SLOT( buttonPressed(int) ) );
  connect( buttonHelp, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotHelp() ) );
  // initialize data fields
  textStockName->setText (i18n ("Investment: %1").arg(stockName));
  textGncSource->setText (i18n ("Quote source: %1").arg(gncSource));
  listKnownSource->insertStringList (WebPriceQuote::quoteSources());
  lineUserSource->setText (gncSource);
  checkAlwaysUse->setChecked(true);
  buttonGroup5->setButton (0);
  buttonPressed (0);
  return;
}

KGncPriceSourceDlg::~KGncPriceSourceDlg()
{
}

enum ButtonIds {NOSOURCE = 0, KMMSOURCE, USERSOURCE};

void KGncPriceSourceDlg::buttonPressed (int buttonId) {
  m_currentButton = buttonId;
  switch (m_currentButton) {
    case NOSOURCE:
      listKnownSource->clearSelection();
      listKnownSource->setEnabled (false);
      lineUserSource->deselect();
      lineUserSource->setEnabled (false);
      break;
    case KMMSOURCE:
      lineUserSource->deselect ();
      lineUserSource->setEnabled (false);
      listKnownSource->setEnabled (true);
      listKnownSource->setFocus();
      listKnownSource->setSelected (0, true);
      break;
    case USERSOURCE:
      listKnownSource->clearSelection();
      listKnownSource->setEnabled (false);
      lineUserSource->setEnabled (true);
      lineUserSource->selectAll();
      lineUserSource->setFocus ();
      break;
  }
}

TQString KGncPriceSourceDlg::selectedSource() const {
  TQString s;
  switch (m_currentButton) {
    case NOSOURCE: s = ""; break;
    case KMMSOURCE: s = listKnownSource->currentText(); break;
    case USERSOURCE: s = lineUserSource->text(); break;
  }
  return (s);
}

void KGncPriceSourceDlg::slotHelp(void)
{
  kapp->invokeHelp ("details.impexp.gncquotes");
}

#include "kgncpricesourcedlg.moc"

