/* ============================================================
 * File  : monthwidget.cpp
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 *         Tom Albers <tomalbers@kde.nl>
 * Date  : 2003-11-03
 * Description :
 *
 * Copyright 2003 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright 2006 by Tom Albers <tomalbers@kde.nl>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// TQt includes.

#include <tqdatetime.h>
#include <tqpainter.h>
#include <tqpixmap.h>
#include <tqevent.h>
#include <tqdragobject.h>
#include <tqstrlist.h>
#include <tqimage.h>

// KDE includes.

#include <kurl.h>
#include <kurldrag.h>
#include <kiconloader.h>
#include <tdefiledialog.h>
#include <kimageio.h>
#include <tdelocale.h>
#include <tdeglobal.h>
#include <tdeapplication.h>
#include <kiconloader.h>
#include <kdebug.h>
#include <tdeio/previewjob.h>
#include <tdeversion.h>
#include <kcalendarsystem.h>

// LibKipi includes.

#include <libkipi/imagedialog.h>

// Local includes.

#include "monthwidget.h"
#include "calsettings.h"

namespace KIPICalendarPlugin
{

MonthWidget::MonthWidget( KIPI::Interface* interface, TQWidget *parent, int month)
    : TQFrame(parent), interface_( interface )
{
    setAcceptDrops(true);
    month_     = month;
    imagePath_ = TQString("");
    pixmap_    = new TQPixmap(SmallIcon("file_broken",
                                       TDEIcon::SizeMedium,
                                       TDEIcon::DisabledState));
    setFixedSize(TQSize(70,90));
    setFrameStyle(TQFrame::Panel|TQFrame::Raised);
}

MonthWidget::~MonthWidget()
{
    if (pixmap_) delete pixmap_;
}

KURL MonthWidget::imagePath()
{
    return imagePath_;
}

void MonthWidget::drawContents(TQPainter *p)
{

#if KDE_IS_VERSION(3,2,0)
    TQString name = TDEGlobal::locale()->calendar()->monthName(month_, CalSettings::instance()->getYear(), true);
#else
    TQString name = TDEGlobal::locale()->monthName(month_, true);
#endif

    TQRect cr;

    cr = contentsRect();
    cr.setBottom(70);
    p->drawPixmap(cr.width()/2 - pixmap_->width()/2,
                  cr.height()/2 - pixmap_->height()/2,
                  *pixmap_);

    cr = contentsRect();
    cr.setTop(70);
    p->drawText(cr,TQt::AlignHCenter,name);
}

void MonthWidget::dragEnterEvent(TQDragEnterEvent* event)
{
    event->accept(TQUriDrag::canDecode(event));
}

void MonthWidget::setImage( const KURL &url )
{
    if (!url.isValid())
        return;

    // check if the file is an image
    if ( ! TQImageIO::imageFormat( url.path() ) )
    {
        kdWarning( 51001 ) << "Unknown image format for: "
                << url.prettyURL() << endl;
        return;
    }

    imagePath_ = url;
    CalSettings::instance()->setImage(month_, imagePath_);

    TDEIconLoader* iconLoader = TDEApplication::kApplication()->iconLoader();
    TQPixmap pix = iconLoader->loadIcon("image-x-generic", TDEIcon::NoGroup, 64 );
    if ( pixmap_ )
        delete pixmap_;
    pixmap_ = new TQPixmap( pix );
    update();

    KURL::List urls;
    urls << url;

    TDEIO::PreviewJob* thumbJob_ =
            TDEIO::filePreview( urls,64);
    connect(thumbJob_, TQ_SIGNAL(gotPreview(const KFileItem*, const TQPixmap&)),
            TQ_SLOT(slotGotThumbnaiL(const KFileItem*, const TQPixmap&)));
}

void MonthWidget::dropEvent(TQDropEvent* event)
{
    KURL::List srcURLs;
    if ( !KURLDrag::decode(event, srcURLs) )
        return;

    if ( srcURLs.isEmpty() )
        return;

    KURL url = srcURLs.first();
    setImage( url );
}

void MonthWidget::slotGotThumbnaiL(const KFileItem* , const TQPixmap& pix)
{
    if ( pixmap_ )
        delete pixmap_;
    TQPixmap image = pix;
    int angle = interface_->info( imagePath_ ).angle();
    if ( angle != 0 ) {
        TQWMatrix matrix;
        matrix.rotate( angle );
        image = image.xForm( matrix );
    }

    pixmap_ = new TQPixmap(image);
    update();
}

void MonthWidget::mouseReleaseEvent(TQMouseEvent* e)
{
    if (!contentsRect().contains(e->pos())) return;

    if (e->button() == TQt::LeftButton)
    {
        KURL url = KIPI::ImageDialog::getImageURL(this, interface_);
        setImage(url);
    }
    else if (e->button() == TQt::RightButton) {
        imagePath_ = TQString("");
        CalSettings::instance()->setImage(month_,imagePath_);
        delete pixmap_;
        pixmap_    = new TQPixmap(SmallIcon("file_broken",
                                           TDEIcon::SizeMedium,
                                           TDEIcon::DisabledState));
        update();
    }
}

}  // NameSpace KIPICalendarPlugin

#include "monthwidget.moc"
