#!/usr/bin/perl -w
use strict;
use blib;

package MyWidget;
use TQt;
use TQt::isa qw(TQt::Widget);

sub NEW {
    shift->SUPER::NEW(@_);

    setMinimumSize(200, 120);
    setMaximumSize(200, 120);

    my $quit = TQt::PushButton("Quit", this, "quit");
    $quit->setGeometry(62, 40, 75, 30);
    $quit->setFont(TQt::Font("Times", 18, &TQt::Font::Bold));

    TQt::app->connect($quit, TQ_SIGNAL('clicked()'), TQ_SLOT('quit()'));
}

package main;
use MyWidget;

my $a = TQt::Application(\@ARGV);

my $w = MyWidget;
$w->setGeometry(100, 100, 200, 120);
$a->setMainWidget($w);
$w->show;
exit $a->exec;
