/***************************************************************************
 *   Copyright (C) 2003 by Sébastien Laoût                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef SETTINGS_H
#define SETTINGS_H

#include <tqstring.h>
#include <kdialogbase.h>
#include <tqcheckbox.h>
#include <tqcombobox.h>
#include <tqtooltip.h>
#include <tqcolor.h>
#include <tqpoint.h>
#include <tqsize.h>
#include <tdecmodule.h>
#include <tdeaction.h>
#include <tdemainwindow.h>
#include <tqdatetime.h>

#include "global.h"
#include "bnpview.h"
#include "systemtray.h"

class TQGroupBox;
class TQButtonGroup;
class KColorCombo;
class KIntNumInput;
class TDEGlobalAccel;
class TQLabel;

class Container;
class SystemTray;
class DebugWindow;
class LinkLook;
class LinkLookEditWidget;
class RunCommandRequester;
class IconSizeCombo;

class TDE_EXPORT GeneralPage : public TDECModule
{
  TQ_OBJECT
  
  public:
	GeneralPage(TQWidget * parent=0, const char * name=0);
	GeneralPage() {};
	virtual ~GeneralPage() {}

	virtual void load();
	virtual void save();
	virtual void defaults();

  private:
	// General
	TQComboBox           *m_treeOnLeft;
	TQComboBox           *m_filterOnTop;
	TQCheckBox           *m_usePassivePopup;

	// System Tray Icon
	TQCheckBox           *m_useSystray;
	TQWidget             *m_systray;
	TQCheckBox           *m_showIconInSystray;
	TQCheckBox           *m_hideOnMouseOut;
	KIntNumInput        *m_timeToHideOnMouseOut;
	TQCheckBox           *m_showOnMouseIn;
	KIntNumInput        *m_timeToShowOnMouseIn;
};

class TDE_EXPORT BasketsPage : public TDECModule
{
  TQ_OBJECT
  
  public:
	BasketsPage(TQWidget * parent=0, const char * name=0);
	BasketsPage() {};

	virtual void load();
	virtual void save();
	virtual void defaults();

  private:
	// Appearance
	TQCheckBox           *m_playAnimations;
	TQCheckBox           *m_showNotesToolTip;
	TQCheckBox           *m_bigNotes;

	// Behavior
	TQCheckBox           *m_autoBullet;
	TQCheckBox           *m_confirmNoteDeletion;
	TQCheckBox           *m_exportTextTags;
	TQWidget             *m_groupOnInsertionLineWidget;
	TQCheckBox           *m_groupOnInsertionLine;
	TQComboBox           *m_middleAction;

	// Protection
	TQCheckBox           *m_useGnuPGAgent;
	TQCheckBox           *m_enableReLockTimeoutMinutes;
	KIntNumInput        *m_reLockTimeoutMinutes;
};

class TDE_EXPORT NewNotesPage : public TDECModule
{
  TQ_OBJECT
  
  public:
	NewNotesPage(TQWidget * parent=0, const char * name=0);
	NewNotesPage() {};

	virtual void load();
	virtual void save();
	virtual void defaults();

  private slots:
	void visualize();

  private:
	// Notes Image Size
	KIntNumInput        *m_imgSizeX;
	KIntNumInput        *m_imgSizeY;
	TQPushButton         *m_pushVisualize;

	// Note Addition
	TQComboBox           *m_newNotesPlace;
	TQCheckBox           *m_viewTextFileContent;
	TQCheckBox           *m_viewHtmlFileContent;
	TQCheckBox           *m_viewImageFileContent;
	TQCheckBox           *m_viewSoundFileContent;
};

class TDE_EXPORT NotesAppearancePage : public TDECModule
{
  TQ_OBJECT
  
  public:
	NotesAppearancePage(TQWidget * parent=0, const char * name=0);
	NotesAppearancePage() {};

	virtual void load();
	virtual void save();
	virtual void defaults();

  private:
	// Link Looks
	LinkLookEditWidget  *m_soundLook;
	LinkLookEditWidget  *m_fileLook;
	LinkLookEditWidget  *m_localLinkLook;
	LinkLookEditWidget  *m_networkLinkLook;
	LinkLookEditWidget  *m_launcherLook;
};

class TDE_EXPORT ApplicationsPage : public TDECModule
{
  TQ_OBJECT
  
  public:
	ApplicationsPage(TQWidget * parent=0, const char * name=0);
	ApplicationsPage() {};

	virtual void load();
	virtual void save();
	virtual void defaults();

  private:
	// Applications
	TQCheckBox           *m_htmlUseProg;
	TQCheckBox           *m_imageUseProg;
	TQCheckBox           *m_animationUseProg;
	TQCheckBox           *m_soundUseProg;
	RunCommandRequester *m_htmlProg;
	RunCommandRequester *m_imageProg;
	RunCommandRequester *m_animationProg;
	RunCommandRequester *m_soundProg;
};

/** Handle all global variables (to avoid lot of extern declarations)
  * @author S�astien Laot
  */
class TDE_EXPORT Settings // FIXME: Distaptch new config events ?
{
  protected:
	/** Main window */
	static bool    s_treeOnLeft;
	static bool    s_filterOnTop;
	static bool    s_playAnimations;
	static bool    s_showNotesToolTip;
	static bool    s_confirmNoteDeletion;
	static bool    s_bigNotes;
	static bool    s_autoBullet;
	static bool    s_exportTextTags;
	static bool    s_useGnuPGAgent;
	static bool    s_usePassivePopup;
	static int     s_middleAction;         // O:Nothing ; 1:Paste ; 2:Text ; 3:Html ; 4:Image ; 5:Link ; 6:Launcher ; 7:Color
	static bool    s_groupOnInsertionLine;
	static bool    s_spellCheckTextNotes;
	static int     s_basketTreeWidth;
	static bool    s_welcomeBasketsAdded;
	static TQString s_dataFolder;
	static TQDate   s_lastBackup;
	static TQPoint  s_mainWindowPosition;
	static TQSize   s_mainWindowSize;
	static bool    s_showEmptyBasketInfo;
	static bool    s_blinkedFilter;
	static bool    s_enableReLockTimeout;
	static int     s_reLockTimeoutMinutes;
	/** Note Addition */
	static int     s_newNotesPlace;        // 0:OnTop ; 1:OnBottom ; 2:AtCurrentNote
	static int     s_viewTextFileContent;
	static int     s_viewHtmlFileContent;
	static int     s_viewImageFileContent;
	static int     s_viewSoundFileContent;
	/** System tray Icon */
	static bool    s_useSystray;
	static bool    s_showIconInSystray;
	static bool    s_startDocked;
	static bool    s_hideOnMouseOut;
	static int     s_timeToHideOnMouseOut;
	static bool    s_showOnMouseIn;
	static int     s_timeToShowOnMouseIn;
	/** Programs */
	static bool    s_htmlUseProg;
	static bool    s_imageUseProg;
	static bool    s_animationUseProg;
	static bool    s_soundUseProg;
	static TQString s_htmlProg;
	static TQString s_imageProg;
	static TQString s_animationProg;
	static TQString s_soundProg;
	/** Insert Note Default Values */
	static int     s_defImageX;
	static int     s_defImageY;
	static int     s_defIconSize;
  public:  /* And the following methods are just getter / setters */
	/** App settings GET */
	static inline bool    treeOnLeft()           { return s_treeOnLeft;           }
	static inline bool    filterOnTop()          { return s_filterOnTop;          }
	static inline bool    playAnimations()       { return s_playAnimations;       }
	static inline bool    showNotesToolTip()     { return s_showNotesToolTip;     }
	static inline bool    confirmNoteDeletion()  { return s_confirmNoteDeletion;  }
	static inline bool    bigNotes()             { return s_bigNotes;             }
	static inline bool    autoBullet()           { return s_autoBullet;           }
	static inline bool    exportTextTags()       { return s_exportTextTags;       }
	static inline bool    useGnuPGAgent()        { return s_useGnuPGAgent;        }
	static inline bool    blinkedFilter()        { return s_blinkedFilter;        }
	static inline bool    enableReLockTimeout()  { return s_enableReLockTimeout;  }
	static inline int     reLockTimeoutMinutes() { return s_reLockTimeoutMinutes; }
	static inline bool    useSystray()           { return s_useSystray;           }
	static inline bool    showIconInSystray()    { return s_showIconInSystray;    }
	static inline bool    startDocked()          { return s_startDocked;          }
	static inline int     middleAction()         { return s_middleAction;         }
	static inline bool    groupOnInsertionLine() { return s_groupOnInsertionLine; }
	static inline bool    spellCheckTextNotes()  { return s_spellCheckTextNotes;  }
	static inline bool    hideOnMouseOut()       { return s_hideOnMouseOut;       }
	static inline int     timeToHideOnMouseOut() { return s_timeToHideOnMouseOut; }
	static inline bool    showOnMouseIn()        { return s_showOnMouseIn;        }
	static inline int     timeToShowOnMouseIn()  { return s_timeToShowOnMouseIn;  }
	static inline int     basketTreeWidth()      { return s_basketTreeWidth;      }
	static inline int     dropTimeToShow()       { return 7;                      } // TODO: 700 ; TODO: There is certainly a TDEGlobalConfig ???
	static inline bool    usePassivePopup()      { return s_usePassivePopup;      }
	static inline bool    welcomeBasketsAdded()  { return s_welcomeBasketsAdded;  }
	static inline TQString dataFolder()           { return s_dataFolder;           }
	static inline TQDate   lastBackup()           { return s_lastBackup;           }
	static inline TQPoint  mainWindowPosition()   { return s_mainWindowPosition;   }
	static inline TQSize   mainWindowSize()       { return s_mainWindowSize;       }
	static inline bool    showEmptyBasketInfo()  { return s_showEmptyBasketInfo;  }
	/** Programs */
	static inline bool    isHtmlUseProg()        { return s_htmlUseProg;          }
	static inline bool    isImageUseProg()       { return s_imageUseProg;         }
	static inline bool    isAnimationUseProg()   { return s_animationUseProg;     }
	static inline bool    isSoundUseProg()       { return s_soundUseProg;         }
	static inline TQString htmlProg()             { return s_htmlProg;             }
	static inline TQString imageProg()            { return s_imageProg;            }
	static inline TQString animationProg()        { return s_animationProg;        }
	static inline TQString soundProg()            { return s_soundProg;            }
	/** Insert Note Default Values */
	static inline int     defImageX()            { return s_defImageX;            }
	static inline int     defImageY()            { return s_defImageY;            }
	static inline int     defIconSize()          { return s_defIconSize;          }
	/** Note Addition */
	static inline int     newNotesPlace()        { return s_newNotesPlace;        }
	static inline int     viewTextFileContent()  { return s_viewTextFileContent;  }
	static inline int     viewHtmlFileContent()  { return s_viewHtmlFileContent;  }
	static inline int     viewImageFileContent() { return s_viewImageFileContent; }
	static inline int     viewSoundFileContent() { return s_viewSoundFileContent; }

	/** App settings SET */
	static void setTreeOnLeft(bool onLeft)
	{
		s_treeOnLeft = onLeft;
		if (Global::bnpView)
			Global::bnpView->setTreePlacement(onLeft);
	}
	static void setFilterOnTop(bool onTop)
	{
		if (s_filterOnTop != onTop) {
			s_filterOnTop = onTop;
			if (Global::bnpView)
				Global::bnpView->filterPlacementChanged(onTop);
		}
	}
	static void setShowNotesToolTip(bool show)
	{
		s_showNotesToolTip = show;
	}
	static void setUseSystray(bool useSystray)
	{
		if (s_useSystray != useSystray) {
			s_useSystray = useSystray;
			if (Global::systemTray != 0L) {
				if (Settings::useSystray())
					Global::systemTray->show();
				else {
					Global::systemTray->hide();
					if(Global::mainWindow()) Global::mainWindow()->show();
				}
			}
			if (Global::bnpView)
				Global::bnpView->m_actHideWindow->setEnabled(useSystray);
		}
	}
	static void setShowIconInSystray(bool show)
	{
		if (s_showIconInSystray != show) {
			s_showIconInSystray = show;
			if (Global::systemTray != 0L && Settings::useSystray())
				Global::systemTray->updateToolTip();
		}
	}
	static inline void setConfirmNoteDeletion(bool confirm)     { s_confirmNoteDeletion  = confirm;     }
	static void setBigNotes(bool big);
	static void setAutoBullet(bool yes);
	static inline void setExportTextTags(bool yes)              { s_exportTextTags       = yes;         }
	static inline void setUseGnuPGAgent(bool yes)               { s_useGnuPGAgent        = yes;         }
	static inline void setPlayAnimations(bool play)             { s_playAnimations       = play;        }
	static inline void setBlinkedFilter(bool blinked)           { s_blinkedFilter        = blinked;     }
	static inline void setEnableReLockTimeout(bool yes)         { s_enableReLockTimeout  = yes;         }
	static inline void setReLockTimeoutMinutes(int minutes)     { s_reLockTimeoutMinutes = minutes;     }
	static inline void setStartDocked(bool docked)              { s_startDocked          = docked;      }
	static inline void setMiddleAction(int action)              { s_middleAction         = action;      }
	static inline void setGroupOnInsertionLine(bool yes)        { s_groupOnInsertionLine = yes;         }
	static inline void setSpellCheckTextNotes(bool yes)         { s_spellCheckTextNotes  = yes;         }
	static inline void setHideOnMouseOut(bool hide)             { s_hideOnMouseOut       = hide;        }
	static inline void setTimeToHideOnMouseOut(int time)        { s_timeToHideOnMouseOut = time;        }
	static inline void setShowOnMouseIn(bool show)              { s_showOnMouseIn        = show;        }
	static inline void setTimeToShowOnMouseIn(int time)         { s_timeToShowOnMouseIn  = time;        }
	static inline void setBasketTreeWidth(int width)            { s_basketTreeWidth      = width;       }
	static inline void setUsePassivePopup(bool enable)          { s_usePassivePopup      = enable;      }
	static inline void setWelcomeBasketsAdded(bool added)       { s_welcomeBasketsAdded  = added;       }
	static inline void setDataFolder(const TQString &folder)     { s_dataFolder           = folder;      }
	static inline void setLastBackup(const TQDate &date)         { s_lastBackup           = date;        }
	static inline void setMainWindowPosition(const TQPoint &pos) { s_mainWindowPosition   = pos;         }
	static inline void setMainWindowSize(const TQSize &size)     { s_mainWindowSize       = size;        }
	static inline void setShowEmptyBasketInfo(bool show)        { s_showEmptyBasketInfo  = show;        }
	// Programs :
	static inline void setIsHtmlUseProg(bool useProg)           { s_htmlUseProg          = useProg;     }
	static inline void setIsImageUseProg(bool useProg)          { s_imageUseProg         = useProg;     }
	static inline void setIsAnimationUseProg(bool useProg)      { s_animationUseProg     = useProg;     }
	static inline void setIsSoundUseProg(bool useProg)          { s_soundUseProg         = useProg;     }
	static inline void setHtmlProg(const TQString &prog)         { s_htmlProg             = prog;        }
	static inline void setImageProg(const TQString &prog)        { s_imageProg            = prog;        }
	static inline void setAnimationProg(const TQString &prog)    { s_animationProg        = prog;        }
	static inline void setSoundProg(const TQString &prog)        { s_soundProg            = prog;        }
	// Insert Note Default Values :
	static inline void setDefImageX(int val)                    { s_defImageX            = val;         }
	static inline void setDefImageY(int val)                    { s_defImageY            = val;         }
	static inline void setDefIconSize(int val)                  { s_defIconSize          = val;         }
	// Note Addition
	static inline void setNewNotesPlace(int val)                { s_newNotesPlace        = val;         }
	static inline void setViewTextFileContent(bool view)        { s_viewTextFileContent  = view;        }
	static inline void setViewHtmlFileContent(bool view)        { s_viewHtmlFileContent  = view;        }
	static inline void setViewImageFileContent(bool view)       { s_viewImageFileContent = view;        }
	static inline void setViewSoundFileContent(bool view)       { s_viewSoundFileContent = view;        }
  public:
	/* Save and load config */
	static void loadConfig();
	static void saveConfig();
  protected:
	static void loadLinkLook(LinkLook *look, const TQString &name, const LinkLook &defaultLook);
	static void saveLinkLook(LinkLook *look, const TQString &name);
};

#endif // SETTINGS_H
